<?php
/*Template Name:Team*/
get_header();
$members = get_field("team_members");
?>

<?php if(count($members) > 1): ?>
<div class="team_nav">
	<a class="prev" href=""><i class="fa fa-angle-left"></i></a>
	<a class="next" href=""><i class="fa fa-angle-right"></i></a>
</div>
<?php endif; ?>
<div class="row">
	<h1><?php the_field("page_heading"); ?></h1>
</div>
<div class="row">
    <?php
        if($members):
    ?>
	<ul class="team_members">
        <?php foreach($members as $member): ?>
		<li>
			<div class="cl col-xs-12 col-sm-5 col-md-5 col-lg-5">
                <?php if($member["member_avatar"]): ?>
				<div class="member animated">
					<img src="<?php echo $member["member_avatar"]["sizes"]["member_thumb"]; ?>" alt="" />
				</div>
                <?php endif; ?>
			</div>
			<div class="cl col-xs-12 col-sm-7 col-md-7 col-lg-7">
				<div class="member_info">
					<h3><?php echo $member["member_name"]; ?></h3>
					<h4><?php echo $member["member_position"]; ?></h4>
					<p><?php echo do_shortcode(nl2br($member["member_description"])); ?></p>
				</div>
			</div>
		</li>
        <?php endforeach; ?>
	</ul>
    <?php endif; ?>
</div>
<script type="text/javascript">
    jQuery(document).ready(function($){
        $('.accordion li:first-child').find('a').addClass('active').find('i').removeClass('fa fa-plus-sign').addClass('fa fa-minus-sign');
        $('.accordion li:first-child').find('.section_content').show();

        $('.tabs .tab_buttons > li:first-child').find('a').addClass('active');
        $('.tabs .tab_content li:first-child').show();
    });
</script>
<?php 
	$team_thumb_format = get_field("thumb_format");
	if($team_thumb_format == "Square"):
?>
<style>
.member{
		border-radius: 0%;
}
</style>
<?php endif;?>

<?php get_footer(); ?>