<?php
/*Template Name:Services*/
get_header();
?>

<div class="services_page">
	<div class="row">
		<h1><?php the_field("page_heading"); ?><?php the_title(); ?></h1>
	</div>
	
	<div class="services-desktop">
    <?php
        $services = get_field("services");
        if($services):
            $odd = false;
            foreach($services as $service):
                if(!$odd):
                    $odd = true;
    ?>

                <div class="row services">

                    <div class="services_article col-xs-12 col-sm-6 col-md-6 col-lg-6 service_text fadeInLeft">
                        <a href="<?php echo $service["service_url"]; ?>"><h5><?php echo $service["service_title"]; ?></h5></a>
                        <p>
                            <?php echo nl2br($service["service_description"]); ?>
                        </p>
                    </div>

                    <div class="services_article col-xs-12 col-sm-6 col-md-6 col-lg-6 service_image fadeInRight">
                        <a href="<?php echo $service["service_url"]; ?>"><img src="<?php echo $service["service_image"]["url"]; ?>" /></a>
                    </div>

                </div>
                <?php
                    else:
                        $odd = false;
                ?>
                <div class="row services">

                    <div class="services_article col-xs-12 col-sm-6 col-md-6 col-lg-6 service_text fadeInLeft">
                        <a href="<?php echo $service["service_url"]; ?>"><img src="<?php echo $service["service_image"]["url"]; ?>" /></a>
                    </div>

                    <div class="services_article col-xs-12 col-sm-6 col-md-6 col-lg-6 service_image fadeInRight">
                        <a href="<?php echo $service["service_url"]; ?>"><h5><?php echo $service["service_title"]; ?></h5></a>
                        <p>
                            <?php echo nl2br($service["service_description"]); ?>
                        </p>
                    </div>

                </div>
        <?php
                endif;
            endforeach;
        endif;
        ?>
		</div>
		
		
	<div class="services-mobile">
    <?php
        $services = get_field("services");
        if($services):
            foreach($services as $service):
    ?>

                <div class="row services">
					
					<div class="services_article col-xs-12 col-sm-6 col-md-6 col-lg-6 service_image fadeInRight">
                        <a href="<?php echo $service["service_url"]; ?>"><img src="<?php echo $service["service_image"]["url"]; ?>" /></a>
                    </div>
					
                    <div class="services_article col-xs-12 col-sm-6 col-md-6 col-lg-6 service_text fadeInLeft">
                        <a href="<?php echo $service["service_url"]; ?>"><h5><?php echo $service["service_title"]; ?></h5></a>
                        <p>
                            <?php echo nl2br($service["service_description"]); ?>
                        </p>
                    </div>

                </div>
        <?php
            endforeach;
        endif;
        ?>
		</div>
</div>
    <style type="text/css">
        .service_text,.service_image{
            opacity: 1;
        }
    </style>
    <script type="text/javascript">
        jQuery(document).ready(function($){
            $(".services").waitForImages(function(){
                $(".services").find(".service_text,.service_image").addClass("animated");

                /*$(".services").waypoint(function(){
                    $(this).find(".service_text,.service_image").addClass("animated");
                },{
                    offset: '100%'
                });
                if(Modernizr.touch){
                    $(".services").find(".service_text,.service_image").addClass("animated");
                }*/
            });
        });
    </script>
<?php get_footer(); ?>