<?php
    if(isset($_REQUEST["um_page"])):
    $the_query;
    if(is_tax()){
        $the_query = $wp_query;
    }else{
        $arguments = array();
        $arguments["post_type"] = "portfolio";
		$exlucde_cats = get_field("exclude_categories");
		$exlucde_cats_arr = array();
		if($exlucde_cats){
			foreach($exlucde_cats as $cat){
				array_push($exlucde_cats_arr,$cat["category"]->slug);
			}
			$arguments["tax_query"] = array(array(
				'taxonomy' => 'portfolio_category',
				'field' => 'slug',
				'terms' => $exlucde_cats_arr,
				'operator' => 'NOT IN'
			));
		}
        $arguments["posts_per_page"] = get_field("number_of_projects_per_page") ? get_field("number_of_projects_per_page") : 6;
        $arguments["paged"] = isset($_REQUEST["um_paged"]) ? $_REQUEST["um_paged"] : '';
        $the_query = new WP_Query( $arguments );
    }
    while ( $the_query->have_posts() ) :  $the_query->the_post();
        $terms = wp_get_post_terms( $post->ID,"portfolio_category" );
        $terms_html_array = array();
        $terms_id_array = array();
        $term_classes = "";
        foreach($terms as $t){
            $term_name = $t->name;
            $term_link = get_term_link($t->slug,$t->taxonomy);
            array_push($terms_html_array,"<a href='{$term_link}'>{$term_name}</a>");
            array_push($terms_id_array,$t->slug);
            $term_classes .= "um_".$t->slug." ";
        }
        $terms_html_array = implode(", ",$terms_html_array);
        ?>
        <li class="<?php echo $term_classes; ?> mix_all portfolio_item">
            <div>
                <div class="post_thumb">
                    <a href="<?php the_permalink(); ?>">
                        <div class="hover_state">
                            <?php if($GLOBALS["um_likes"]): ?>
                                <p class="likes"><i class="fa fa-heart"></i> <?php echo get_likes(); ?></p>
                            <?php endif; ?>
                            <p class="cont"><i class="fa fa-search"></i></p>
                        </div>
                        <?php the_post_thumbnail("project_thumb"); ?>
                </div>
                <a href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4></a>
                <?php if($terms_html_array): ?>
                    <div class="categories_inside">
                        <?php echo $terms_html_array; ?>
                    </div>
                <?php
                endif;
                if(get_field("fancybox_portfolio","options") == "Enabled"){
                    get_template_part("content","fancybox");
                }
                ?>
            </div>
        </li>
    <?php
        endwhile;
        die;
    endif;
    ?>
<?php
    /*Template Name:Projects*/
    get_header();
?>

    <div class="row">
		<h1>
		<?php
			if(is_tax()){
				$category = get_query_var("portfolio_category");
				$category = get_term_by("slug",$category,"portfolio_category");
				echo $category->name;
			}else{
				the_field("page_heading");
			}
		?>
        </h1>
        <?php
        $arguments = array();
        if(is_tax()){
            $parent = get_term_by("slug",get_query_var("portfolio_category"),"portfolio_category");
            $arguments["child_of"] = $parent->term_id;
        }else{
			$exlucde_cats = get_field("exclude_categories");
			$exlucde_cats_arr = array();
			if($exlucde_cats){
				foreach($exlucde_cats as $cat){
					array_push($exlucde_cats_arr,$cat["category"]->term_id);
				}
				$arguments["exclude_tree"] = $exlucde_cats_arr;
			}
		}
        $terms = get_terms("portfolio_category",$arguments);
        if($terms && get_field("enable_or_disable_project_filter","options") != "Disabled" && !is_tax()):
            ?>
            <div class="categories-p mixitup">
                <ul class="col-sm-12">
                    <li><a href="#" data-filter="mix_all" class="active"><?php _e("All","um_lang"); ?></a></li>
                    <?php foreach($terms as $term):$term_link = get_term_link($term->slug,$term->taxonomy);?>
                        <li><a href="<?php echo $term_link;?>" data-filter="um_<?php echo $term->slug; ?>"><?php echo $term->name; ?></a></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>
	
	<div class="project_list_h row">

        <?php
        $the_query;
        if(is_tax()){
            $the_query = $wp_query;
        }else{
            $arguments = array();
            $arguments["post_type"] = "portfolio";
			$exlucde_cats = get_field("exclude_categories");
            $exlucde_cats_arr = array();
            if($exlucde_cats){
                foreach($exlucde_cats as $cat){
                    array_push($exlucde_cats_arr,$cat["category"]->slug);
                }
                $arguments["tax_query"] = array(array(
                    'taxonomy' => 'portfolio_category',
                    'field' => 'slug',
                    'terms' => $exlucde_cats_arr,
                    'operator' => 'NOT IN'
                ));
            }
            $arguments["posts_per_page"] = get_field("number_of_projects_per_page") ? get_field("number_of_projects_per_page") : 6;
            $arguments["paged"] = isset($_REQUEST["um_paged"]) ? $_REQUEST["um_paged"] : '';
            $the_query = new WP_Query( $arguments );
        }
        if($the_query->found_posts):
        ?>
		<div class="project_list_holder scroll_projects <?php echo get_field("menu_position","options") != "Top" ? "proj_holder_menu_top" : ""; ?>">
			<ul>
                <?php
                while ( $the_query->have_posts() ) :  $the_query->the_post();
                    $terms = wp_get_post_terms( $post->ID,"portfolio_category" );
                    $terms_html_array = array();
                    $terms_id_array = array();
                    $term_classes = "";
                    foreach($terms as $t){
                        $term_name = $t->name;
                        $term_link = get_term_link($t->slug,$t->taxonomy);
                        array_push($terms_html_array,"<a href='{$term_link}'>{$term_name}</a>");
                        array_push($terms_id_array,$t->slug);
                        $term_classes .= "um_".$t->slug." ";
                    }
                    $terms_html_array = implode(", ",$terms_html_array);
                ?>
				<li class="<?php echo $term_classes; ?> mix_all portfolio_item">
					<div>
                        <div class="post_thumb">
                            <a href="<?php the_permalink(); ?>">
                                <div class="hover_state">
                                    <?php if($GLOBALS["um_likes"]): ?>
                                        <p class="likes"><i class="fa fa-heart"></i> <?php echo get_likes(); ?></p>
                                    <?php endif; ?>
                                    <p class="cont"><i class="fa fa-search"></i></p>
                                </div>
                            <?php the_post_thumbnail("project_thumb"); ?>
                        </div>
                        <a href="<?php the_permalink(); ?>" class="project_title"><h4><?php the_title(); ?></h4></a>
                        <div class="categories_inside">
                            <?php echo $terms_html_array; ?>
                        </div>
                        <?php
                            if(get_field("fancybox_portfolio","options") == "Enabled"){
                                get_template_part("content","fancybox");
                            }
                        ?>
                    </div>
				</li>
                <?php endwhile; ?>
                <?php if($the_query->max_num_pages): ?>
                    <li class="load_more_projects load_more_projects_horizontal" style="display:block"><a class="load_more" href=""><?php _e("Load More","um_lang"); ?></a></li>
                <?php endif; ?>
			</ul>

		</div>
        <?php endif; ?>
	</div>
    <script type="text/javascript">
        project_page = 1;
        jQuery(document).ready(function($){
            setup_fancy_box();
			show_loader();
            $('.project_list_h').waitForImages( function() {
                $(".project_list_holder ul").mixitup({
                    targetSelector : "li.portfolio_item",
                    filterLogic : "and",
                    multiFilter : true
                });
                $('.project_list_holder ul').css("width",$('.project_list_holder ul li').length * ($('.project_list_holder ul li:eq(0)').width() + 24));
                calc_slider_width();
                $('.scroll_projects').niceScroll();
				hide_loader();
            });
        });
    </script>
<?php get_footer(); ?>