        <?php
/*Template Name:Home*/
get_header();
?>
    <?php
    $socials = get_field("social_medias","options");
    if($socials):
        ?>
        <div class="<?php echo get_field("menu_position","options") == "Top" ? "social_bottom" : "social"; ?> hidden-xs social_js">
            <a href="#" id="share"><i class="fa fa-thumbs-up"></i></a>
            <?php foreach($socials as $soc): ?>
                <a target="_blank" href="<?php echo $soc["social_url"]; ?>" class="social_network animated fadeOutDown"><i class="fa <?php echo str_replace("icon-","fa fa-",$soc["social_profile"]); ?>"></i></a>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <?php
        $slider_or_video = get_field("slider_or_video");
        if($slider_or_video == "Slider"):
    ?>

    <?php
        $slides = get_field("slider");
        if($slides):
    ?>
    <div id="slides" class="">
        <ul class="slides-container">
            <?php
                foreach($slides as $slide):
                $media_type = isset($slide["media_type"]) && $slide["media_type"] == "Video" ? "Video" : "Image";
            ?>
            <li data-video-volume="<?php echo isset($slide["video_volume"]) ? $slide["video_volume"] : "0"; ?>">
                <?php if($slide["image"] && $media_type == "Image"): ?>
                    <img src="<?php echo $slide["image"]; ?>" alt=""/>
                <?php elseif($media_type == "Video"): ?>
                    <?php if(wp_is_mobile()): ?>
                        <?php if($slide["video_poster"]): ?>
                            <img src="<?php echo $slide["video_poster"]; ?>" alt=""/>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if($slide["video_url"]): ?>
                            <?php echo getVideoEmbed($slide["video_url"]); ?>
                        <?php elseif($slide["video_mp4"] || $slide["video_vp8"] || $slide["video_ogg"]): ?>
                            <video loop="loop">
                                <?php if($slide["video_mp4"]): ?>
                                    <source type="video/mp4" src="<?php echo $slide["video_mp4"]; ?>">
                                <?php
                                    endif;
                                if($slide["video_vp8"]): ?>
                                    <source type="video/webm" src="<?php echo $slide["video_vp8"]; ?>">
                                <?php
                                    endif;
                                if($slide["video_ogg"]): ?>
                                    <source type="video/ogg" src="<?php echo $slide["video_ogg"]; ?>">
                                <?php endif; ?>
                            </video>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
				<div class="img_overlay" style="opacity: <?php echo $slide["overlay_opacity"]; ?>;background: <?php the_field("overlay_color"); ?>"></div>
                <div class="capture">
                    <p class="<?php echo $slide["text_animation"]; ?>" ><?php echo $slide["label"];?></p>
                    <?php if($slide["button_url"] && $slide["button_text"]): ?>
                        <br style="clear: both"/>
                        <a class="<?php echo $slide["button_animation"]; ?>" href="<?php echo $slide["button_url"]; ?>"><?php echo $slide["button_text"]; ?></a>
                    <?php endif; ?>
                    <?php if($slide["custom_html"]): ?>
                        <br style="clear: both"/>
                        <div class="<?php echo $slide["button_animation"]; ?> custom_markup">
                            <?php echo $slide["custom_html"]; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </li>
            <?php endforeach; ?>
        </ul>
        <?php if(get_field("enable_or_disable_arrows_on_background_slider","options") != "Disabled"): ?>
        <nav class="slides-navigation <?php echo get_field("menu_position","options") == "Top" ? "slides-navigation_bottom" : ""; ?>">
            <a href="#" class="next"><i class="fa fa-angle-right"></i></a>
            <a href="#" class="prev"><i class="fa fa-angle-left"></i></a>
        </nav>
        <?php endif; ?>
    </div>

    <script type="text/javascript">
        jQuery(document).ready(function($){
            var slides = $("#slides");
            slides.superslides({
                animation : "<?php the_field("slider_animation"); ?>",
                pagination : false,
                play : <?php echo get_field("autoplay") == "Enabled" ? get_field("autoplay_delay") ? get_field("autoplay_delay") : "8000" : "0"; ?>
            });
            /*Swipe*/
			if(slides.find("li").length > 1){
				slides.swipe({
					swipe:function(event, direction, distance, duration, fingerCount) {
						//$("#slides").superslides('next');
						if(direction == 'right'){
							slides.superslides('animate' , 'prev');
						}else{
							slides.superslides('animate' , 'next');
						}
					}
				});
			}
            /*Swipe*/
            function animate_slides(){
                var cur_slide = $(".slides-control li:eq("+$('div#slides').superslides('current')+")");
                /*Animate Paragraph*/
                $(".slides-control li div.capture p").removeClass("animated");
                cur_slide.find("div.capture p").addClass("animated");
                /*Animate Anchors*/
                $(".slides-control li div.capture a").removeClass("animated");
                $(".slides-control li div.capture div").removeClass("animated");
                window.setTimeout(function(){
                    cur_slide.find("div.capture a").addClass("animated");
                    cur_slide.find("div.capture div").addClass("animated");
                },500);
                pasueVimeo($(".slides-control"),cur_slide);
                pasueYoutube($(".slides-control"),cur_slide);
                $(".slides-control").find("video").each(function(){ this.pause(); });
                cur_slide.find("video").each(function(){ this.play(); });
            };
			
			$('.inner_content , #slides li iframe').waitForImages(function(){
				animate_slides();
                $(".slides-container iframe").each(function(){
                   center_video($(this));
                });
                $('video').mediaelementplayer({
                    pluginPath : template_directory+"/assets/mediaelement/",
                    startVolume : parseFloat("0"),
                    loop: true,
                    features : [],
                    enableAutosize : false,
                    videoWidth : "100%",
                    videoHeight : "100%",
                });
                $(".slides-control li").each(function(){
                    var cur_slide = $(this);
					var vol = cur_slide.data("video-volume");
                    pasueVimeo($(".slides-control"),cur_slide);
                    pasueYoutube($(".slides-control"),cur_slide);
                    cur_slide.find("video").each(function(){ this.pause(); });
                    cur_slide.find("video").each(function(){ this.play();this.setVolume(0) });
                });
			});
			
            $(window).resize(function(){
                $(".slides-container iframe").each(function(){
                    center_video($(this));
                });
            });
			
            $("div#slides").on("animated.slides",animate_slides);
			
			$("#slides li iframe").load(function(){
				animate_slides();
			});
        });
    </script>
    <?php endif; ?>
    <?php else: ?>
        <div class="capture cap_video">
            <?php if(get_field("label")): ?>
                <p class="fadeInDown">
                    <?php the_field("label"); ?>
                </p>
            <?php endif;?>
            <br style="clear: both">
            <?php if(get_field("button_text") && get_field("button_url")): ?>
                <a class="fadeInDown" href="<?php the_field("button_url"); ?>"><?php the_field("button_text"); ?></a>
            <?php endif; ?>
        </div>

        <div class="video_fullscreen">
            <div class="video_overlay" style="opacity:0.5;background: #000"></div>
            <?php
            $url = get_field("video_url");
            $youtube = "";
            $vimeo = "";
            if($url):
                preg_match("#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=v\/)[^&\n]+|(?<=v=)[^&\n]+|(?<=youtu.be/)[^&\n]+#", $url, $youtube);
                sscanf(parse_url($url, PHP_URL_PATH), '/%d', $vimeo);
                if($vimeo):
                    ?>
                    <iframe class="vimeo" src="http://player.vimeo.com/video/<?php echo $vimeo; ?>?api=1&autoplay=1" width="100%" height="100%" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
                <?php else: ?>
                    <div id="ov_vid" data-vid="<?php echo $youtube[0]; ?>"></div>
                <?php endif; ?>
            <?php else: ?>
                <video autoplay="autoplay" id="player" loop="loop" controls="controls">
                    <?php if(get_field("video_mp4")): ?>
                        <source type="video/mp4" src="<?php the_field("video_mp4"); ?>" />
                    <?php elseif(get_field("video_mp4_url")): ?>
                        <source type="video/mp4" src="<?php the_field("video_mp4_url"); ?>" />
                    <?php endif; ?>

                    <?php if(get_field("video_vp8")): ?>
                        <source type="video/webm" src="<?php the_field("video_vp8"); ?>" />
                    <?php elseif(get_field("video_vp8_url")): ?>
                        <source type="video/webm" src="<?php the_field("video_vp8_url"); ?>" />
                    <?php endif; ?>

                    <?php if(get_field("video_ogg")): ?>
                        <source type="video/ogg" src="<?php the_field("video_ogg"); ?>" />
                    <?php elseif(get_field("video_ogg_url")): ?>
                        <source type="video/ogg" src="<?php the_field("video_ogg_url"); ?>" />
                    <?php endif; ?>
                </video>
            <?php endif; ?>
        </div>

        <style>
			.capture p , .capture a{
				opacity:0;
			}
			.capture p.animated , .capture a.animated{
				opacity:1;
			}
		</style>

        <div id="slides" style="display: none">
            <ul class="slides-container">
                <li>
                    <?php if(get_field("video_poster")): ?>
                        <img src="<?php the_field("video_poster"); ?>"/>
                    <?php endif; ?>
                    <div class="img_overlay" style="opacity: 0.1;background: #000000"></div>
                </li>
            </ul>
        </div>


        <script type="text/javascript">
            var touch = Modernizr.touch;
			var onYouTubeIframeAPIReady;
			var youtube_did_it = false;
			function center_video(el){
				var playerBox = el;
				var win = {};
				var el = jQuery(window);

				win.width = el.width();
				win.height = el.height();

				var margin = 24;
				var vid = {};
				vid.width = win.width + ((win.width * margin) / 100);
				vid.height = Math.ceil((9 * win.width) / 16);
				vid.marginTop = -((vid.height - win.height) / 2);
				vid.marginLeft = -((win.width * (margin / 2)) / 100);

				if (vid.height < win.height) {
					vid.height = win.height + ((win.height * margin) / 100);
					vid.width = Math.floor((16 * win.height) / 9);
					vid.marginTop = -((win.height * (margin / 2)) / 100);
					vid.marginLeft = -((vid.width - win.width) / 2);
				}
				playerBox.css({width: vid.width, height: vid.height, marginTop: vid.marginTop, marginLeft: vid.marginLeft});
			}
			<?php if($youtube): ?>
			/*Youtube API*/
			function onYouTubePlayerAPIReady() {
				var vid = jQuery("#ov_vid").data("vid");
				var player = new YT.Player('ov_vid', {
								height: '100%',
								width: '100%',
								videoId: vid,
								playerVars: { 'h1' : 1 , 'modestbranding' : 0, 'disablekb' : 1, 'autoplay': 1, 'controls': 0, 'playlist': vid, 'loop': 1, 'showinfo': 0, 'wmode': 'transparent' , 'iv_load_policy' : '3'},
								events: {
									'onReady': onPlayerReady
								}
							});
				youtube_did_it = true;
				center_video(jQuery(".video_fullscreen iframe"));
			}
			function onPlayerReady(event) {
				event.target.setVolume(parseFloat("<?php the_field("video_volume"); ?>") * 10);
			}
			/*Youtube API*/
			<?php endif; ?>
			jQuery(document).ready(function($){

				$(".video_fullscreen").css("height",$(window).height());
				$(".video_fullscreen").css("width",$(window).width());
					
				$(window).resize(function(){
					center_video(jQuery(".video_fullscreen iframe"));
				});
				$(window).load(function(){
					center_video(jQuery(".video_fullscreen iframe"));
				});
				$(".inner_content").waitForImages(function(){
					center_video(jQuery(".video_fullscreen iframe"));
				});
				<?php if($youtube && isset($_REQUEST["um_ajax_load_site"])): ?>
					if(!youtube_did_it){
						onYouTubePlayerAPIReady();
					}
				<?php endif; ?>
				if(!touch){
				<?php if($vimeo): ?>
				/*Vimeo API*/
				var f = jQuery('iframe.vimeo');
				url = f.attr('src').split('?')[0];
				if (window.addEventListener) {
					window.addEventListener('message', onMessageReceived, false);
				}
				else {
					window.attachEvent('onmessage', onMessageReceived, false);
				}
				function post(action, value) {
					var data = { method: action };

					if (value) {
						data.value = value;
					}

					f[0].contentWindow.postMessage(JSON.stringify(data), url);
				}
				function onMessageReceived(e) {
					var data = JSON.parse(e.data);

					switch (data.event) {
						case 'ready':
							onReady();
							break;
					}
				}
				function onReady() {
					post("play","");
					post("setLoop","1");
					post("setVolume",parseFloat("<?php the_field("video_volume"); ?>"));
					center_video(jQuery(".video_fullscreen iframe"));
				}
				/*Vimeo API*/
				<?php endif; ?>
				}
					var touch = Modernizr.touch;
					if(touch){
						jQuery(".video_fullscreen").next().hide();
						jQuery(".video_fullscreen").hide();
						jQuery("#slides").show();
						jQuery("#slides").superslides({
							pagination : false
						});
					}else{
						jQuery('video').mediaelementplayer({
							pluginPath : template_directory+"/assets/mediaelement/",
							startVolume : parseFloat("<?php the_field("video_volume"); ?>"),
							loop: true,
							features : [],
							enableAutosize : false,
							videoWidth : "100%",
							videoHeight : "100%"
						});
					}
										
					$(".inner_content").waitForImages(function(){
						$(".capture a , .capture p").addClass("animated");
                        $(".video_fullscreen").css("height",$(window).height());
                        $(".video_fullscreen").css("width",$(window).width());
					});
					
                    $(window).resize(function(){
                        $(".video_fullscreen").css("height",$(window).height());
                        $(".video_fullscreen").css("width",$(window).width());
                    });
            });
        </script>
    <?php endif; ?>

<?php get_footer(); ?>
    