<?php

if(!class_exists('WooCommerce_Twitter_Bootstrap')){

    class WooCommerce_Twitter_Bootstrap
    {
        /*
        * Construct the plugin object
        */
        public function __construct(){
            //load_plugin_textdomain( 'wootb', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
            //add_action('admin_init', array(&$this, 'admin_init'));
            //add_action('admin_menu', array(&$this, 'add_menu'));
            add_filter( 'init', array( $this, 'init' ) );
        }

        function featured_products( $atts ) {

            extract(shortcode_atts(array(
                'per_page' => 12,
                'columns' => 4,
                'orderby' => 'date',
                'order' => 'desc',
                'content_product_template' => 'bs-content-product'
            ), $atts));

            $args = array(
                'post_type'=> 'product',
                'post_status' => 'publish',
                'ignore_sticky_posts'=> 1,
                'posts_per_page' => $per_page,
                'orderby' => $orderby,
                'order' => $order,
                'meta_query' => array(
                    array(
                        'key' => '_visibility',
                        'value' => array('catalog', 'visible'),
                        'compare' => 'IN'
                    ),
                    array(
                        'key' => '_featured',
                        'value' => 'yes'
                    )
                )
            );

            return $this->showproductspeciallist($args,$content_product_template,$columns);

        }

        /**
         * Recent Products shortcode
         *
         * @access public
         * @param array $atts
         * @return string
         */
        public function recent_products( $atts ) {

            global $woocommerce;

            extract(shortcode_atts(array(
                'per_page' => '12',
                'columns' => '4',
                'orderby' => 'date',
                'order' => 'desc',
                'content_product_template' => 'bs-content-product'
            ), $atts));

            $meta_query = $woocommerce->query->get_meta_query();

            $args = array(
                'post_type'=> 'product',
                'post_status' => 'publish',
                'ignore_sticky_posts'=> 1,
                'posts_per_page' => $per_page,
                'orderby' => $orderby,
                'order' => $order,
                'meta_query' => $meta_query
            );

            return $this->showproductspeciallist($args,$content_product_template,$columns);

        }

        function showproductspeciallist($args,$content_product_template,$columns=null)
        {

            global $woocommerce_loop;
            ob_start();

            $products= new WP_Query( $args );

            $woocommerce_loop['columns'] = ($columns) ? $columns:3;

            if ( $products->have_posts() )
            {
                bs_shop_loop($products,$content_product_template,$columns);
            }

            wp_reset_postdata();
            return '<div class="woocommerce">' . ob_get_clean() . '</div>';
        }


        function init()
        {
            remove_shortcode( 'featured_products' );
            add_shortcode( 'featured_products', array($this, 'featured_products' ));
            remove_shortcode( 'recent_products' );
            add_shortcode( 'recent_products', array($this, 'recent_products' ));

            function get_grid_classes($woocommerce_loop){

                switch($woocommerce_loop['columns'])
                {
	case 6: $classes = 'col-xs-6 col-sm-3 col-md-2'; break;
	case 4: $classes = 'col-xs-12 col-sm-6 col-md-3'; break;
	case 3: $classes = 'col-xs-12 col-sm-6 col-md-4 col-lg-4'; break;
	case 31: $classes = 'col-xs-12 col-sm-6 col-md-4'; break;
	case 2: $classes = 'col-xs-12 col-sm-6 col-md-6'; break;
	default: $classes = 'col-xs-12 col-sm-12 col-md-12';
                }
                return $classes;
            }


            function bs_product_loop(&$woocommerce_loop,$classes,$template='bs-content-product'){
                $template = get_template_directory().'/includes/woocommerce-twitterbootstrap/templates/'.$template.'.php';
                include($template);



                    if($woocommerce_loop['columns'] == 6)
                    {
                        if(0 == ($woocommerce_loop['loop'] % 6)){?><div class="clearfix visible-md visible-lg"></div><?php }
                        if(0 == ($woocommerce_loop['loop'] % 4)){?><div class="clearfix visible-sm"></div><?php }
                        if(0 == ($woocommerce_loop['loop'] % 2)){?><div class="clearfix visible-xs"></div><?php }
                    }
                    elseif($woocommerce_loop['columns'] == 4)
                    {
                        if(0 == ($woocommerce_loop['loop'] % 4)){?><div class="clearfix visible-md visible-lg"></div><?php }
                        if(0 == ($woocommerce_loop['loop'] % 2)){?><div class="clearfix visible-sm"></div><?php }
                    }
                    elseif($woocommerce_loop['columns'] == 3)
                    {
                        if(0 == ($woocommerce_loop['loop'] % 3)){?><div class="clearfix visible-md visible-lg"></div><?php }
                    }
                    elseif($woocommerce_loop['columns'] == 31)
                    {
                        if(0 == ($woocommerce_loop['loop'] % 3)){?><div class="clearfix visible-md visible-lg"></div><?php }
                        if(0 == ($woocommerce_loop['loop'] % 2)){?><div class="clearfix visible-sm"></div><?php }
                    }
                    elseif($woocommerce_loop['columns'] == 2)
                    {
                        if(0 == ($woocommerce_loop['loop'] % 2)){?><div class="clearfix invisible-xs"></div><?php }
                    }
                $woocommerce_loop['loop']++;



            }

            add_action( 'shop_loop', 'bs_shop_loop', 99 );

            function bs_shop_loop($product=null,$template='bs-content-product',$columns=null)
            {

                $woocommerce_loop = array('loop'=>0,'columns' => ($columns)?$columns:3);


                /* double check */
                if($woocommerce_loop['columns']!=31 && ( $woocommerce_loop['columns']>6 || in_array($woocommerce_loop['columns'],array(5,7)))) { return; }


                // Increase loop count
                $woocommerce_loop['loop']++;


                woocommerce_product_subcategories(array("before"=>"<br style='clear:both'/><ul class='um_categories'>","after"=>"</ul>"));

                $classes = get_grid_classes($woocommerce_loop);

                if($product)
                {

                    ?><div class="clearfix"></div><div class="products"><div class="row"><?php

                    while ( $product->have_posts()) : $product->the_post();
                        bs_product_loop($woocommerce_loop,$classes,$template);
                    endwhile;

                }
                else
                {
                    ?><div class="clearfix"></div><div class="products"><div class="row"><?php

                    while ( have_posts() ) : the_post();
                        bs_product_loop($woocommerce_loop,$classes);
                    endwhile;

                }
                if($woocommerce_loop['columns']==31)$woocommerce_loop['columns']=3;
                if ( 0 != ($woocommerce_loop['loop']-1) % $woocommerce_loop['columns'] )
                {

                    ?><div class="<?php echo $classes?>"></div><?php
                    while ( 0 != $woocommerce_loop['loop'] % $woocommerce_loop['columns'] )
                    {
                        $woocommerce_loop['loop']++;
                        ?><div class="<?php echo $classes?>"></div><?php
                    }

                }

                ?></div></div><?php

            }


            function my_template_redirect(){
                //pages you want to make true, ex. is_shop()
                global $woocommerce;

                if(
                    is_shop() ||
                    is_product_category()

                )
                {
                    load_template(get_template_directory().'/includes/woocommerce-twitterbootstrap/templates/bs-archive-product.php');

                    exit;
                }
                /*else if(is_product_category())
                {
                    load_template($plugin_dir . 'templates/bs-content-product_cat.php');
                    exit;
                }*/

            }

            add_action('template_redirect','my_template_redirect');




// --------------------
// --  PLUGIN HOOKS  --
// --------------------

//remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
//remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
            add_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper_bs', 10 );
            add_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end_bs', 10 );


            if ( ! function_exists( 'woocommerce_output_content_wrapper_bs' ) ) {

                /**
                 * Output the start of the page wrapper.
                 *
                 * @access public
                 * @return void
                 */
                function woocommerce_output_content_wrapper_bs() {

                    woocommerce_get_template( 'shop/wrapper-start.php' );
                }
            }
            if ( ! function_exists( 'woocommerce_output_content_wrapper_end_bs' ) ) {

                /**
                 * Output the end of the page wrapper.
                 *
                 * @access public
                 * @return void
                 */
                function woocommerce_output_content_wrapper_end_bs() {
                    woocommerce_get_template( 'shop/wrapper-end.php' );
                }
            }



            add_action( 'woocommerce_before_single_product_summary', 'woocommerce_before_single_product_summary_bs', 1 );
            function woocommerce_before_single_product_summary_bs() {

                if(get_option( 'tbversion', 3 )==2)
                {
                    $bssingleproductclass = 'span6';
                }
                else
                {
                    $bssingleproductclass = 'col-sm-6';
                }

                echo '<div class="row"><div class="'.$bssingleproductclass.' bssingleproduct">';

            }


            add_action( 'woocommerce_before_single_product_summary', 'woocommerce_before_single_product_summary_bs_end', 100 );
            function woocommerce_before_single_product_summary_bs_end() { echo '</div>
<div class="col-sm-6 bssingleproduct">'; }

            add_action( 'woocommerce_after_single_product_summary', 'woocommerce_after_single_product_summary_bs', 1 );
            function woocommerce_after_single_product_summary_bs() { echo '</div>
</div>'; }

            /* thumbnails */

            add_action('bs_before_shop_loop_item_title','bs_get_product_thumbnail',10,3);
            function bs_get_product_thumbnail()
            {

                global $post;

                $doc = new DOMDocument();
                $doc->loadHTML(get_the_post_thumbnail($post->ID, 'medium'));
                $images = $doc->getElementsByTagName('img');
                foreach ($images as $image) {
                    $image->setAttribute('class',$image->getAttribute('class').' img-responsive');
                    $image->removeAttribute('height');
                    $image->removeAttribute('width');
//see: http://stackoverflow.com/questions/6321481/printing-out-html-content-from-domelement-using-nodevalue
                    echo utf8_decode($doc->saveXML($image)); break;
                }

            }


            /* the grid display */
            /*
            |  	columns		| mobile 	| tablet 	| desktop	|per page 	|
            ----------------------------------------------------|-----------|
            |		1		|	1		|	1		|	1		| 	10		|
            |---------------------------------------------------|-----------|
            |		2		|	1		|	2		|	2		|	10		|
            |---------------------------------------------------|-----------|
            |		3		|	1		|	1		|	3		|	 9		|
            |---------------------------------------------------|-----------|
            |		3(1)	|	1		|	2		|	3		|	12		|
            |---------------------------------------------------|-----------|
            |		4		|	1		|	2		|	4		|	12		|
            |---------------------------------------------------|-----------|
            |		5		|	n/a		|	n/a		|	n/a		|	n/a	    |
            |---------------------------------------------------|-----------|
            |		6		|	2		|	4		|	6		|	12		|
            |---------------------------------------------------|-----------|
            |		>=6		|	n/a		|	n/a		|	n/a		|	n/a		|
            |---------------------------------------------------------------|

            */

// Store column count for displaying the grid
            global $woocommerce_loop;

            if ( empty( $woocommerce_loop['columns'] ) )
            {
                $woocommerce_loop['columns'] = 3;
            }


            if($woocommerce_loop['columns']==3)
            {
                add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 9;' ), 10 );
            }
            elseif($woocommerce_loop['columns']>2)
            {
                add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 12;' ), 10 );
            }

            add_action('woocommerce_before_shop_loop','setupgrid',40);

            function setupgrid()
            {

                global $woocommerce_loop;

                /* set up grid variables */


// Store loop count we're currently on
                if ( empty( $woocommerce_loop['loop'] ) )
                    $woocommerce_loop['loop'] = 0;



                if($woocommerce_loop['columns']!=31 && ($woocommerce_loop['columns']>6 || in_array($woocommerce_loop['columns'],array(5,7))))
                {
                    echo '<div class="alert alert-error">
  <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  Wrong number of columns.
</div>';
                }

            }

        }



    } // END class

}

if(class_exists('WooCommerce_Twitter_Bootstrap')){
    $woocommercetwitterbootstrap = new WooCommerce_Twitter_Bootstrap();
}
