<?php

class acf_field_ui_drag extends acf_field
{
	// vars
	var $settings, // will hold info such as dir / path
		$defaults; // will hold default field options
		
		
	/*
	*  __construct
	*
	*  Set name / label needed for actions / filters
	*
	*  @since	3.6
	*  @date	23/01/13
	*/
	
	function __construct()
	{
		// vars
		$this->name = 'ui_drag';
		$this->label = __('UI Drag');
		$this->category = __("Basic",'acf'); // Basic, Content, Choice, etc
		$this->defaults = array(
			// add default here to merge into your field. 
			// This makes life easy when creating the field options as you don't need to use any if( isset('') ) logic. eg:
			//'preview_size' => 'thumbnail'
		);
		
		
		// do not delete!
    	parent::__construct();
    	
    	
    	// settings
		$this->settings = array(
			'path' => apply_filters('acf/helpers/get_path', __FILE__),
			'dir' => apply_filters('acf/helpers/get_dir', __FILE__),
			'version' => '1.0.0'
		);

	}
	
	
	/*
	*  create_options()
	*
	*  Create extra options for your field. This is rendered when editing a field.
	*  The value of $field['name'] can be used (like bellow) to save extra data to the $field
	*
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*
	*  @param	$field	- an array holding all the field's data
	*/
	
	function create_options( $field )
	{
		// defaults?
		/*
		$field = array_merge($this->defaults, $field);
		*/
		
		// key is needed in the field names to correctly save the data
		$key = $field['name'];
		
		
		// Create Field Options HTML
		?>
        <tr class="field_option field_option_<?php echo $this->name; ?>">
            <td class="label">
                <label><?php _e("Preview Size",'acf'); ?></label>
                <p class="description"><?php _e("Thumbnail is advised",'acf'); ?></p>
            </td>
            <td>
                <?php

                do_action('acf/create_field', array(
                    'type'		=>	'radio',
                    'name'		=>	'fields['.$key.'][preview_size]',
                    'value'		=>	$field['preview_size'],
                    'layout'	=>	'horizontal',
                    'choices'	=>	array(
                        'thumbnail' => __('Thumbnail'),
                        'something_else' => __('Something Else'),
                    )
                ));

                ?>
            </td>
        </tr>
		<?php
		
	}
	
	
	/*
	*  create_field()
	*
	*  Create the HTML interface for your field
	*
	*  @param	$field - an array holding all the field's data
	*
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*/
	
	function create_field( $field )
	{
        $values = json_decode($field["value"],true);
        $img = isset($values["img"]) && $values["img"] ? wp_get_attachment_image_src($values["img"],"full") : "";
        $points = isset($values["points"]) && $values["points"] ? $values["points"] : "";
		?>
		<div class="udrg_container">
            <a class="udrg_add_picker" href="#">Add Point</a>
            <a class="udrg_remove_image" href="#">Remove Image</a>
            <br style="clear: both"/>
            <div class="udrg_dialog <?php echo !$img ? "no-image" : ""; ?>">
                <img class="udrg_holder" src="<?php echo isset($img[0]) ? $img[0] : "" ;?>" alt="" data-image="<?php echo isset($values["img"]) ? $values["img"] : ""; ?>"/>
                <a class="udrg_choose_image" href="#">Choose Image</a>
                <?php
                    if($points):
                        foreach($points as $p):
                ?>
                        <a style="top:<?php echo $p["top"]; ?>%;left:<?php echo $p["left"]; ?>%;" class="udrg_point" href="#" data-top="<?php echo $p["top"]; ?>" data-left="<?php echo $p["left"]; ?>" data-desc="<?php echo $p["desc"]; ?>">

                        </a>
                <?php
                        endforeach;
                    endif;
                ?>
            </div>
            <div class="udrg_palete">
                <textarea name="" id="" cols="30" rows="10"></textarea>
                <a class="udrg_save_pointer_desc" href="#">Save</a>
                <a class="udrg_remove_pointer" href="#">Remove</a>
            </div>
            <input type="hidden" id="udrg_json_container" name="<?php echo $field["name"]; ?>" value='<?php echo $field['value']; ?>'/>
		</div>
		<script> var allow_html_on_pin = <?php echo get_field("allow_html_pin_points","options") == "Enabled" ? "true" : "false"; ?> </script>
		<?php
	}
	
	
	/*
	*  input_admin_enqueue_scripts()
	*
	*  This action is called in the admin_enqueue_scripts action on the edit screen where your field is created.
	*  Use this action to add css + javascript to assist your create_field() action.
	*
	*  $info	http://codex.wordpress.org/Plugin_API/Action_Reference/admin_enqueue_scripts
	*  @type	action
	*  @since	3.6
	*  @date	23/01/13
	*/

	function input_admin_enqueue_scripts()
	{
		// Note: This function can be removed if not used
		
		
		// register acf scripts
		wp_register_script( 'acf-input-ui_drag', $this->settings['dir'] . 'js/input.js', array('acf-input'), $this->settings['version'] );
		wp_register_style( 'acf-input-ui_drag', $this->settings['dir'] . 'css/input.css', array('acf-input'), $this->settings['version'] );

        wp_enqueue_script('jquery-ui-core');
        wp_enqueue_script('jquery-ui-draggable');
		// scripts
		wp_enqueue_script(array(
			'acf-input-ui_drag',	
		));

		// styles
		wp_enqueue_style(array(
			'acf-input-ui_drag',	
		));
		
		
	}

	/*
	*  format_value_for_api()
	*
	*  This filter is appied to the $value after it is loaded from the db and before it is passed back to the api functions such as the_field
	*
	*  @type	filter
	*  @since	3.6
	*  @date	23/01/13
	*
	*  @param	$value	- the value which was loaded from the database
	*  @param	$post_id - the $post_id from which the value was loaded
	*  @param	$field	- the field array holding all the field options
	*
	*  @return	$value	- the modified value
	*/
	
	function format_value_for_api( $value, $post_id, $field )
	{
        if($value){
            $value = json_decode($value,true);
            $img = isset($value["img"]) && $value["img"] ? wp_get_attachment_image_src($value["img"],"full") : "";
            $value["img"] = isset($img[0]) ? $img[0] : "";
            return $value;
        }else{
		    return $value;
        }
	}
	
	
	/*
	*  load_field()
	*
	*  This filter is appied to the $field after it is loaded from the database
	*
	*  @type	filter
	*  @since	3.6
	*  @date	23/01/13
	*
	*  @param	$field - the field array holding all the field options
	*
	*  @return	$field - the field array holding all the field options
	*/
	
	function load_field( $field )
	{
		// Note: This function can be removed if not used
		return $field;
	}

}

// create field
new acf_field_ui_drag();

?>