(function($){

	$(document).live('acf/setup_fields', function(e, postbox){

	});

    var construct_data = function(parent){
        var img;
        var points = [];
        var img = parent.find("img.udrg_holder").attr("data-image");
        parent.find("a.udrg_point").each(function(){
            var el = $(this);
            var tmp_point = {
                top : el.attr("data-top"),
                left : el.attr("data-left"),
                desc : el.attr("data-desc")
            };
            points.push(tmp_point);
        });
        var output = {
            img : img,
            points : points
        };
        output = JSON.stringify(output);
        parent.find("input:hidden#udrg_json_container").val(output);
    };

    jQuery(document).ready(function($){

        var file_frame;
        var cur_ui;
        var cur_point;

        var construct_dragable = function(){
          $("a.udrg_point").draggable({
              containment: "parent",
              scroll: false,
              stop : function(event,ui){
                  calc_point_pos($(ui.helper));
                  construct_data($(ui.helper).parent().parent());
              }
          });
        };
        construct_dragable();

        var calc_point_pos = function(point){
            point = $(point);
            var x = $(point).position().top / $(point).parent().height() * 100;
            var y = $(point).position().left / $(point).parent().width() * 100;
            point.attr("data-top",parseInt(x));
            point.attr("data-left",parseInt(y));
        };

        var insert_point = function(parent){
            var point_markup = '<a class="udrg_point" href="#" data-top="0" data-left="0" data-desc=""></a>';
            point_markup = $(point_markup);
            parent.find(".udrg_dialog").append(point_markup);
            construct_dragable();
            calc_point_pos(point_markup);
            construct_data(parent);
        }

        var clear_points = function(parent){
            parent.find("a.udrg_point").remove();
            construct_data(parent);
        }

        $("a.udrg_remove_pointer").live("click",function(e){
            e.preventDefault();
            cur_point.remove();
            construct_data($(this).parent().parent());
        });

        $("a.udrg_save_pointer_desc").live("click",function(e){
            e.preventDefault();
            e.stopPropagation();
			if(allow_html_on_pin){
				var value = Base64.encode($(this).prev().val());
			}else{
				var value = $(this).prev().val();
			}			
            cur_point.attr("data-desc",value);
            $(".udrg_palete").hide();
            construct_data($(this).parent().parent());
        });

        $(".udrg_palete, .udrg_palete textarea").click(function(e){
            //e.preventDefault();
            //e.stopPropagation();
        });

        $("a.udrg_point").live("click",function(e){
            e.preventDefault();
            e.stopPropagation();
            cur_point = $(this);
            cur_point.parent().parent().find(".udrg_palete").find("textarea").val("");
			if(allow_html_on_pin){
				var desc = Base64.decode($(this).attr("data-desc"));
			}else{
				var desc = $(this).attr("data-desc");
			}           
            cur_point.parent().parent().find(".udrg_palete").find("textarea").val(desc);
            $(".udrg_palete").hide();
            cur_point.parent().parent().find(".udrg_palete").show();
        });

        $("a.udrg_add_picker").live("click",function(e){
            e.preventDefault();
            var parent = $(this).parent();
            insert_point(parent);
        });

        $('.udrg_choose_image').live('click', function( event ){
            event.preventDefault();
            cur_ui = $(this).parent().parent();
            if ( file_frame ) {
                file_frame.open();
                return;
            }
        });

        $(".udrg_remove_image").live("click",function(e){
            e.preventDefault();
            var parent = $(this).parent();
            parent.find(".udrg_dialog").addClass("no-image");
            parent.find("img.udrg_holder").attr("src","");
            parent.find("img.udrg_holder").attr("data-image","0");
            clear_points(parent);
            //construct_data(parent);
        });

        file_frame = wp.media.frames.file_frame = wp.media({
            title: jQuery( this ).data( 'uploader_title' ),
            button: {
                text: jQuery( this ).data( 'uploader_button_text' )
            },
            library : {
                type: 'image'
            },
            multiple: false
        });

        file_frame.on( 'select', function() {
            var attachment = file_frame.state().get('selection').first().toJSON();
            var att_id = attachment.id;
            var att_url = attachment.url;
            if(att_url && att_id){
                var img = cur_ui.find("img.udrg_holder");
                img.attr("src",att_url);
                img.attr("data-image",att_id);
                img.parent().removeClass("no-image");
                construct_data(cur_ui);
            }
        });

        $("body").click(function(e){
            //$(".udrg_palete").hide();
        });
    });

})(jQuery);
var Base64 = {
 
    // private property
    _keyStr : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
 
    // public method for encoding
    encode : function (input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
 
        input = Base64._utf8_encode(input);
 
        while (i < input.length) {
 
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
 
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
 
            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }
 
            output = output +
            this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
            this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
 
        }
 
        return output;
    },
 
    // public method for decoding
    decode : function (input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;
 
        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
 
        while (i < input.length) {
 
            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
 
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;
 
            output = output + String.fromCharCode(chr1);
 
            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }
 
        }
 
        output = Base64._utf8_decode(output);
 
        return output;
 
    },
 
    // private method for UTF-8 encoding
    _utf8_encode : function (string) {
        string = string.replace(/\r\n/g,"\n");
        var utftext = "";
 
        for (var n = 0; n < string.length; n++) {
 
            var c = string.charCodeAt(n);
 
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
 
        }
 
        return utftext;
    },
 
    // private method for UTF-8 decoding
    _utf8_decode : function (utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;
 
        while ( i < utftext.length ) {
 
            c = utftext.charCodeAt(i);
 
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i+1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i+1);
                c3 = utftext.charCodeAt(i+2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
 
        }
 
        return string;
    }
 
}