<?php
if(function_exists("register_field_group"))
{
    register_field_group(array (
        'id' => 'acf_branding',
        'title' => 'Branding',
        'fields' => array (
            array (
                'key' => 'field_5294b9adecbeb',
                'label' => 'Enable or Disable Arrows on Background Slider',
                'name' => 'enable_or_disable_arrows_on_background_slider',
                'type' => 'radio',
                'instructions' => 'Enable or Disable Arrows on Background Slider',
                'choices' => array (
                    'Enabled' => 'Enabled',
                    'Disabled' => 'Disabled',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => 'Enabled',
                'layout' => 'vertical',
            ),
			array (
                'key' => 'field_5294b9adecbe12',
                'label' => 'Enable or Disable Portrait Mode On Single Project',
                'name' => 'single_project_portrait',
                'type' => 'radio',
                'instructions' => 'Enable or Disable Portrait Mode On Single Project',
                'choices' => array (
                    'Disabled' => 'Disabled',
					'Enabled' => 'Enabled',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => 'Disabled',
                'layout' => 'vertical',
            ),
            array (
                'key' => 'field_5294b9c3ecbec',
                'label' => 'Enable or Disable Project Filter',
                'name' => 'enable_or_disable_project_filter',
                'type' => 'radio',
                'instructions' => 'Enable or Disable Project Filter',
                'choices' => array (
                    'Enabled' => 'Enabled',
                    'Disabled' => 'Disabled',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => 'Enabled',
                'layout' => 'vertical',
            ),
            array (
                'key' => 'field_5294b9e1ecbed',
                'label' => 'Main Logo',
                'name' => 'main_logo',
                'type' => 'file',
                'instructions' => 'Upload the site logo from this field.',
                'save_format' => 'url',
                'library' => 'all',
            ),
            array (
                'key' => 'field_5294b9f8ecbee',
                'label' => 'Favicon',
                'name' => 'favicon',
                'type' => 'file',
                'instructions' => 'Upload your site favicon from this field.',
                'save_format' => 'url',
                'library' => 'all',
            ),
            array (
                'key' => 'field_5294ba0cecbef',
                'label' => 'Smartphone Logo',
                'name' => 'smartphone_logo',
                'type' => 'file',
                'instructions' => 'Upload a .png image to display on bookmarked smartphones.',
                'save_format' => 'url',
                'library' => 'all',
            ),
            array (
                'key' => 'field_5294ba26ecbf0',
                'label' => 'Google Fonts',
                'name' => 'google_fonts',
                'type' => 'select',
                'instructions' => 'Choose a google font if you want to change the main font.',
                'choices' => array (
                    0 => '--None--',
                    1 => 'ABeeZee',
                    2 => 'Abel',
                    3 => 'Abril Fatface',
                    4 => 'Aclonica',
                    5 => 'Acme',
                    6 => 'Actor',
                    7 => 'Adamina',
                    8 => 'Advent Pro',
                    9 => 'Aguafina Script',
                    10 => 'Akronim',
                    11 => 'Aladin',
                    12 => 'Aldrich',
                    13 => 'Alegreya',
                    14 => 'Alegreya SC',
                    15 => 'Alex Brush',
                    16 => 'Alfa Slab One',
                    17 => 'Alice',
                    18 => 'Alike',
                    19 => 'Alike Angular',
                    20 => 'Allan',
                    21 => 'Allerta',
                    22 => 'Allerta Stencil',
                    23 => 'Allura',
                    24 => 'Almendra',
                    25 => 'Almendra Display',
                    26 => 'Almendra SC',
                    27 => 'Amarante',
                    28 => 'Amaranth',
                    29 => 'Amatic SC',
                    30 => 'Amethysta',
                    31 => 'Anaheim',
                    32 => 'Andada',
                    33 => 'Andika',
                    34 => 'Angkor',
                    35 => 'Annie Use Your Telescope',
                    36 => 'Anonymous Pro',
                    37 => 'Antic',
                    38 => 'Antic Didone',
                    39 => 'Antic Slab',
                    40 => 'Anton',
                    41 => 'Arapey',
                    42 => 'Arbutus',
                    43 => 'Arbutus Slab',
                    44 => 'Architects Daughter',
                    45 => 'Archivo Black',
                    46 => 'Archivo Narrow',
                    47 => 'Arimo',
                    48 => 'Arizonia',
                    49 => 'Armata',
                    50 => 'Artifika',
                    51 => 'Arvo',
                    52 => 'Asap',
                    53 => 'Asset',
                    54 => 'Astloch',
                    55 => 'Asul',
                    56 => 'Atomic Age',
                    57 => 'Aubrey',
                    58 => 'Audiowide',
                    59 => 'Autour One',
                    60 => 'Average',
                    61 => 'Average Sans',
                    62 => 'Averia Gruesa Libre',
                    63 => 'Averia Libre',
                    64 => 'Averia Sans Libre',
                    65 => 'Averia Serif Libre',
                    66 => 'Bad Script',
                    67 => 'Balthazar',
                    68 => 'Bangers',
                    69 => 'Basic',
                    70 => 'Battambang',
                    71 => 'Baumans',
                    72 => 'Bayon',
                    73 => 'Belgrano',
                    74 => 'Belleza',
                    75 => 'BenchNine',
                    76 => 'Bentham',
                    77 => 'Berkshire Swash',
                    78 => 'Bevan',
                    79 => 'Bigelow Rules',
                    80 => 'Bigshot One',
                    81 => 'Bilbo',
                    82 => 'Bilbo Swash Caps',
                    83 => 'Bitter',
                    84 => 'Black Ops One',
                    85 => 'Bokor',
                    86 => 'Bonbon',
                    87 => 'Boogaloo',
                    88 => 'Bowlby One',
                    89 => 'Bowlby One SC',
                    90 => 'Brawler',
                    91 => 'Bree Serif',
                    92 => 'Bubblegum Sans',
                    93 => 'Bubbler One',
                    94 => 'Buda',
                    95 => 'Buenard',
                    96 => 'Butcherman',
                    97 => 'Butterfly Kids',
                    98 => 'Cabin',
                    99 => 'Cabin Condensed',
                    100 => 'Cabin Sketch',
                    101 => 'Caesar Dressing',
                    102 => 'Cagliostro',
                    103 => 'Calligraffitti',
                    104 => 'Cambo',
                    105 => 'Candal',
                    106 => 'Cantarell',
                    107 => 'Cantata One',
                    108 => 'Cantora One',
                    109 => 'Capriola',
                    110 => 'Cardo',
                    111 => 'Carme',
                    112 => 'Carrois Gothic',
                    113 => 'Carrois Gothic SC',
                    114 => 'Carter One',
                    115 => 'Caudex',
                    116 => 'Cedarville Cursive',
                    117 => 'Ceviche One',
                    118 => 'Changa One',
                    119 => 'Chango',
                    120 => 'Chau Philomene One',
                    121 => 'Chela One',
                    122 => 'Chelsea Market',
                    123 => 'Chenla',
                    124 => 'Cherry Cream Soda',
                    125 => 'Cherry Swash',
                    126 => 'Chewy',
                    127 => 'Chicle',
                    128 => 'Chivo',
                    129 => 'Cinzel',
                    130 => 'Cinzel Decorative',
                    131 => 'Clicker Script',
                    132 => 'Coda',
                    133 => 'Coda Caption',
                    134 => 'Codystar',
                    135 => 'Combo',
                    136 => 'Comfortaa',
                    137 => 'Coming Soon',
                    138 => 'Concert One',
                    139 => 'Condiment',
                    140 => 'Content',
                    141 => 'Contrail One',
                    142 => 'Convergence',
                    143 => 'Cookie',
                    144 => 'Copse',
                    145 => 'Corben',
                    146 => 'Courgette',
                    147 => 'Cousine',
                    148 => 'Coustard',
                    149 => 'Covered By Your Grace',
                    150 => 'Crafty Girls',
                    151 => 'Creepster',
                    152 => 'Crete Round',
                    153 => 'Crimson Text',
                    154 => 'Croissant One',
                    155 => 'Crushed',
                    156 => 'Cuprum',
                    157 => 'Cutive',
                    158 => 'Cutive Mono',
                    159 => 'Damion',
                    160 => 'Dancing Script',
                    161 => 'Dangrek',
                    162 => 'Dawning of a New Day',
                    163 => 'Days One',
                    164 => 'Delius',
                    165 => 'Delius Swash Caps',
                    166 => 'Delius Unicase',
                    167 => 'Della Respira',
                    168 => 'Denk One',
                    169 => 'Devonshire',
                    170 => 'Didact Gothic',
                    171 => 'Diplomata',
                    172 => 'Diplomata SC',
                    173 => 'Domine',
                    174 => 'Donegal One',
                    175 => 'Doppio One',
                    176 => 'Dorsa',
                    177 => 'Dosis',
                    178 => 'Dr Sugiyama',
                    179 => 'Droid Sans',
                    180 => 'Droid Sans Mono',
                    181 => 'Droid Serif',
                    182 => 'Duru Sans',
                    183 => 'Dynalight',
                    184 => 'EB Garamond',
                    185 => 'Eagle Lake',
                    186 => 'Eater',
                    187 => 'Economica',
                    188 => 'Electrolize',
                    189 => 'Elsie',
                    190 => 'Elsie Swash Caps',
                    191 => 'Emblema One',
                    192 => 'Emilys Candy',
                    193 => 'Engagement',
                    194 => 'Englebert',
                    195 => 'Enriqueta',
                    196 => 'Erica One',
                    197 => 'Esteban',
                    198 => 'Euphoria Script',
                    199 => 'Ewert',
                    200 => 'Exo',
                    201 => 'Expletus Sans',
                    202 => 'Fanwood Text',
                    203 => 'Fascinate',
                    204 => 'Fascinate Inline',
                    205 => 'Faster One',
                    206 => 'Fasthand',
                    207 => 'Federant',
                    208 => 'Federo',
                    209 => 'Felipa',
                    210 => 'Fenix',
                    211 => 'Finger Paint',
                    212 => 'Fjalla One',
                    213 => 'Fjord One',
                    214 => 'Flamenco',
                    215 => 'Flavors',
                    216 => 'Fondamento',
                    217 => 'Fontdiner Swanky',
                    218 => 'Forum',
                    219 => 'Francois One',
                    220 => 'Freckle Face',
                    221 => 'Fredericka the Great',
                    222 => 'Fredoka One',
                    223 => 'Freehand',
                    224 => 'Fresca',
                    225 => 'Frijole',
                    226 => 'Fruktur',
                    227 => 'Fugaz One',
                    228 => 'GFS Didot',
                    229 => 'GFS Neohellenic',
                    230 => 'Gabriela',
                    231 => 'Gafata',
                    232 => 'Galdeano',
                    233 => 'Galindo',
                    234 => 'Gentium Basic',
                    235 => 'Gentium Book Basic',
                    236 => 'Geo',
                    237 => 'Geostar',
                    238 => 'Geostar Fill',
                    239 => 'Germania One',
                    240 => 'Gilda Display',
                    241 => 'Give You Glory',
                    242 => 'Glass Antiqua',
                    243 => 'Glegoo',
                    244 => 'Gloria Hallelujah',
                    245 => 'Goblin One',
                    246 => 'Gochi Hand',
                    247 => 'Gorditas',
                    248 => 'Goudy Bookletter 1911',
                    249 => 'Graduate',
                    250 => 'Grand Hotel',
                    251 => 'Gravitas One',
                    252 => 'Great Vibes',
                    253 => 'Griffy',
                    254 => 'Gruppo',
                    255 => 'Gudea',
                    256 => 'Habibi',
                    257 => 'Hammersmith One',
                    258 => 'Hanalei',
                    259 => 'Hanalei Fill',
                    260 => 'Handlee',
                    261 => 'Hanuman',
                    262 => 'Happy Monkey',
                    263 => 'Headland One',
                    264 => 'Henny Penny',
                    265 => 'Herr Von Muellerhoff',
                    266 => 'Holtwood One SC',
                    267 => 'Homemade Apple',
                    268 => 'Homenaje',
                    269 => 'IM Fell DW Pica',
                    270 => 'IM Fell DW Pica SC',
                    271 => 'IM Fell Double Pica',
                    272 => 'IM Fell Double Pica SC',
                    273 => 'IM Fell English',
                    274 => 'IM Fell English SC',
                    275 => 'IM Fell French Canon',
                    276 => 'IM Fell French Canon SC',
                    277 => 'IM Fell Great Primer',
                    278 => 'IM Fell Great Primer SC',
                    279 => 'Iceberg',
                    280 => 'Iceland',
                    281 => 'Imprima',
                    282 => 'Inconsolata',
                    283 => 'Inder',
                    284 => 'Indie Flower',
                    285 => 'Inika',
                    286 => 'Irish Grover',
                    287 => 'Istok Web',
                    288 => 'Italiana',
                    289 => 'Italianno',
                    290 => 'Jacques Francois',
                    291 => 'Jacques Francois Shadow',
                    292 => 'Jim Nightshade',
                    293 => 'Jockey One',
                    294 => 'Jolly Lodger',
                    295 => 'Josefin Sans',
                    296 => 'Josefin Slab',
                    297 => 'Joti One',
                    298 => 'Judson',
                    299 => 'Julee',
                    300 => 'Julius Sans One',
                    301 => 'Junge',
                    302 => 'Jura',
                    303 => 'Just Another Hand',
                    304 => 'Just Me Again Down Here',
                    305 => 'Kameron',
                    306 => 'Karla',
                    307 => 'Kaushan Script',
                    308 => 'Kavoon',
                    309 => 'Keania One',
                    310 => 'Kelly Slab',
                    311 => 'Kenia',
                    312 => 'Khmer',
                    313 => 'Kite One',
                    314 => 'Knewave',
                    315 => 'Kotta One',
                    316 => 'Koulen',
                    317 => 'Kranky',
                    318 => 'Kreon',
                    319 => 'Kristi',
                    320 => 'Krona One',
                    321 => 'La Belle Aurore',
                    322 => 'Lancelot',
                    323 => 'Lato',
                    324 => 'League Script',
                    325 => 'Leckerli One',
                    326 => 'Ledger',
                    327 => 'Lekton',
                    328 => 'Lemon',
                    329 => 'Libre Baskerville',
                    330 => 'Life Savers',
                    331 => 'Lilita One',
                    332 => 'Limelight',
                    333 => 'Linden Hill',
                    334 => 'Lobster',
                    335 => 'Lobster Two',
                    336 => 'Londrina Outline',
                    337 => 'Londrina Shadow',
                    338 => 'Londrina Sketch',
                    339 => 'Londrina Solid',
                    340 => 'Lora',
                    341 => 'Love Ya Like A Sister',
                    342 => 'Loved by the King',
                    343 => 'Lovers Quarrel',
                    344 => 'Luckiest Guy',
                    345 => 'Lusitana',
                    346 => 'Lustria',
                    347 => 'Macondo',
                    348 => 'Macondo Swash Caps',
                    349 => 'Magra',
                    350 => 'Maiden Orange',
                    351 => 'Mako',
                    352 => 'Marcellus',
                    353 => 'Marcellus SC',
                    354 => 'Marck Script',
                    355 => 'Margarine',
                    356 => 'Marko One',
                    357 => 'Marmelad',
                    358 => 'Marvel',
                    359 => 'Mate',
                    360 => 'Mate SC',
                    361 => 'Maven Pro',
                    362 => 'McLaren',
                    363 => 'Meddon',
                    364 => 'MedievalSharp',
                    365 => 'Medula One',
                    366 => 'Megrim',
                    367 => 'Meie Script',
                    368 => 'Merienda',
                    369 => 'Merienda One',
                    370 => 'Merriweather',
                    371 => 'Merriweather Sans',
                    372 => 'Metal',
                    373 => 'Metal Mania',
                    374 => 'Metamorphous',
                    375 => 'Metrophobic',
                    376 => 'Michroma',
                    377 => 'Milonga',
                    378 => 'Miltonian',
                    379 => 'Miltonian Tattoo',
                    380 => 'Miniver',
                    381 => 'Miss Fajardose',
                    382 => 'Modern Antiqua',
                    383 => 'Molengo',
                    384 => 'Molle',
                    385 => 'Monda',
                    386 => 'Monofett',
                    387 => 'Monoton',
                    388 => 'Monsieur La Doulaise',
                    389 => 'Montaga',
                    390 => 'Montez',
                    391 => 'Montserrat',
                    392 => 'Montserrat Alternates',
                    393 => 'Montserrat Subrayada',
                    394 => 'Moul',
                    395 => 'Moulpali',
                    396 => 'Mountains of Christmas',
                    397 => 'Mouse Memoirs',
                    398 => 'Mr Bedfort',
                    399 => 'Mr Dafoe',
                    400 => 'Mr De Haviland',
                    401 => 'Mrs Saint Delafield',
                    402 => 'Mrs Sheppards',
                    403 => 'Muli',
                    404 => 'Mystery Quest',
                    405 => 'Neucha',
                    406 => 'Neuton',
                    407 => 'New Rocker',
                    408 => 'News Cycle',
                    409 => 'Niconne',
                    410 => 'Nixie One',
                    411 => 'Nobile',
                    412 => 'Nokora',
                    413 => 'Norican',
                    414 => 'Nosifer',
                    415 => 'Nothing You Could Do',
                    416 => 'Noticia Text',
                    417 => 'Noto Sans',
                    418 => 'Noto Serif',
                    419 => 'Nova Cut',
                    420 => 'Nova Flat',
                    421 => 'Nova Mono',
                    422 => 'Nova Oval',
                    423 => 'Nova Round',
                    424 => 'Nova Script',
                    425 => 'Nova Slim',
                    426 => 'Nova Square',
                    427 => 'Numans',
                    428 => 'Nunito',
                    429 => 'Odor Mean Chey',
                    430 => 'Offside',
                    431 => 'Old Standard TT',
                    432 => 'Oldenburg',
                    433 => 'Oleo Script',
                    434 => 'Oleo Script Swash Caps',
                    435 => 'Open Sans',
                    436 => 'Open Sans Condensed',
                    437 => 'Oranienbaum',
                    438 => 'Orbitron',
                    439 => 'Oregano',
                    440 => 'Orienta',
                    441 => 'Original Surfer',
                    442 => 'Oswald',
                    443 => 'Over the Rainbow',
                    444 => 'Overlock',
                    445 => 'Overlock SC',
                    446 => 'Ovo',
                    447 => 'Oxygen',
                    448 => 'Oxygen Mono',
                    449 => 'PT Mono',
                    450 => 'PT Sans',
                    451 => 'PT Sans Caption',
                    452 => 'PT Sans Narrow',
                    453 => 'PT Serif',
                    454 => 'PT Serif Caption',
                    455 => 'Pacifico',
                    456 => 'Paprika',
                    457 => 'Parisienne',
                    458 => 'Passero One',
                    459 => 'Passion One',
                    460 => 'Patrick Hand',
                    461 => 'Patrick Hand SC',
                    462 => 'Patua One',
                    463 => 'Paytone One',
                    464 => 'Peralta',
                    465 => 'Permanent Marker',
                    466 => 'Petit Formal Script',
                    467 => 'Petrona',
                    468 => 'Philosopher',
                    469 => 'Piedra',
                    470 => 'Pinyon Script',
                    471 => 'Pirata One',
                    472 => 'Plaster',
                    473 => 'Play',
                    474 => 'Playball',
                    475 => 'Playfair Display',
                    476 => 'Playfair Display SC',
                    477 => 'Podkova',
                    478 => 'Poiret One',
                    479 => 'Poller One',
                    480 => 'Poly',
                    481 => 'Pompiere',
                    482 => 'Pontano Sans',
                    483 => 'Port Lligat Sans',
                    484 => 'Port Lligat Slab',
                    485 => 'Prata',
                    486 => 'Preahvihear',
                    487 => 'Press Start 2P',
                    488 => 'Princess Sofia',
                    489 => 'Prociono',
                    490 => 'Prosto One',
                    491 => 'Puritan',
                    492 => 'Purple Purse',
                    493 => 'Quando',
                    494 => 'Quantico',
                    495 => 'Quattrocento',
                    496 => 'Quattrocento Sans',
                    497 => 'Questrial',
                    498 => 'Quicksand',
                    499 => 'Quintessential',
                    500 => 'Qwigley',
                    501 => 'Racing Sans One',
                    502 => 'Radley',
                    503 => 'Raleway',
                    504 => 'Raleway Dots',
                    505 => 'Rambla',
                    506 => 'Rammetto One',
                    507 => 'Ranchers',
                    508 => 'Rancho',
                    509 => 'Rationale',
                    510 => 'Redressed',
                    511 => 'Reenie Beanie',
                    512 => 'Revalia',
                    513 => 'Ribeye',
                    514 => 'Ribeye Marrow',
                    515 => 'Righteous',
                    516 => 'Risque',
                    517 => 'Roboto',
                    518 => 'Roboto Condensed',
                    519 => 'Rochester',
                    520 => 'Rock Salt',
                    521 => 'Rokkitt',
                    522 => 'Romanesco',
                    523 => 'Ropa Sans',
                    524 => 'Rosario',
                    525 => 'Rosarivo',
                    526 => 'Rouge Script',
                    527 => 'Ruda',
                    528 => 'Rufina',
                    529 => 'Ruge Boogie',
                    530 => 'Ruluko',
                    531 => 'Rum Raisin',
                    532 => 'Ruslan Display',
                    533 => 'Russo One',
                    534 => 'Ruthie',
                    535 => 'Rye',
                    536 => 'Sacramento',
                    537 => 'Sail',
                    538 => 'Salsa',
                    539 => 'Sanchez',
                    540 => 'Sancreek',
                    541 => 'Sansita One',
                    542 => 'Sarina',
                    543 => 'Satisfy',
                    544 => 'Scada',
                    545 => 'Schoolbell',
                    546 => 'Seaweed Script',
                    547 => 'Sevillana',
                    548 => 'Seymour One',
                    549 => 'Shadows Into Light',
                    550 => 'Shadows Into Light Two',
                    551 => 'Shanti',
                    552 => 'Share',
                    553 => 'Share Tech',
                    554 => 'Share Tech Mono',
                    555 => 'Shojumaru',
                    556 => 'Short Stack',
                    557 => 'Siemreap',
                    558 => 'Sigmar One',
                    559 => 'Signika',
                    560 => 'Signika Negative',
                    561 => 'Simonetta',
                    562 => 'Sintony',
                    563 => 'Sirin Stencil',
                    564 => 'Six Caps',
                    565 => 'Skranji',
                    566 => 'Slackey',
                    567 => 'Smokum',
                    568 => 'Smythe',
                    569 => 'Sniglet',
                    570 => 'Snippet',
                    571 => 'Snowburst One',
                    572 => 'Sofadi One',
                    573 => 'Sofia',
                    574 => 'Sonsie One',
                    575 => 'Sorts Mill Goudy',
                    576 => 'Source Code Pro',
                    577 => 'Source Sans Pro',
                    578 => 'Special Elite',
                    579 => 'Spicy Rice',
                    580 => 'Spinnaker',
                    581 => 'Spirax',
                    582 => 'Squada One',
                    583 => 'Stalemate',
                    584 => 'Stalinist One',
                    585 => 'Stardos Stencil',
                    586 => 'Stint Ultra Condensed',
                    587 => 'Stint Ultra Expanded',
                    588 => 'Stoke',
                    589 => 'Strait',
                    590 => 'Sue Ellen Francisco',
                    591 => 'Sunshiney',
                    592 => 'Supermercado One',
                    593 => 'Suwannaphum',
                    594 => 'Swanky and Moo Moo',
                    595 => 'Syncopate',
                    596 => 'Tangerine',
                    597 => 'Taprom',
                    598 => 'Tauri',
                    599 => 'Telex',
                    600 => 'Tenor Sans',
                    601 => 'Text Me One',
                    602 => 'The Girl Next Door',
                    603 => 'Tienne',
                    604 => 'Tinos',
                    605 => 'Titan One',
                    606 => 'Titillium Web',
                    607 => 'Trade Winds',
                    608 => 'Trocchi',
                    609 => 'Trochut',
                    610 => 'Trykker',
                    611 => 'Tulpen One',
                    612 => 'Ubuntu',
                    613 => 'Ubuntu Condensed',
                    614 => 'Ubuntu Mono',
                    615 => 'Ultra',
                    616 => 'Uncial Antiqua',
                    617 => 'Underdog',
                    618 => 'Unica One',
                    619 => 'UnifrakturCook',
                    620 => 'UnifrakturMaguntia',
                    621 => 'Unkempt',
                    622 => 'Unlock',
                    623 => 'Unna',
                    624 => 'VT323',
                    625 => 'Vampiro One',
                    626 => 'Varela',
                    627 => 'Varela Round',
                    628 => 'Vast Shadow',
                    629 => 'Vibur',
                    630 => 'Vidaloka',
                    631 => 'Viga',
                    632 => 'Voces',
                    633 => 'Volkhov',
                    634 => 'Vollkorn',
                    635 => 'Voltaire',
                    636 => 'Waiting for the Sunrise',
                    637 => 'Wallpoet',
                    638 => 'Walter Turncoat',
                    639 => 'Warnes',
                    640 => 'Wellfleet',
                    641 => 'Wendy One',
                    642 => 'Wire One',
                    643 => 'Yanone Kaffeesatz',
                    644 => 'Yellowtail',
                    645 => 'Yeseva One',
                    646 => 'Yesteryear',
                    647 => 'Zeyada',
                ),
                'default_value' => '',
                'allow_null' => 0,
                'multiple' => 0,
            ),
            array (
                'key' => 'field_5294ba42ecbf1',
                'label' => 'Skin Mode',
                'name' => 'skin_mode',
                'type' => 'radio',
                'instructions' => 'Choose the skin mode.',
                'choices' => array (
                    'Light' => 'Light',
                    'Dark' => 'Dark',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => 'Light',
                'layout' => 'vertical',
            ),
            array (
                'key' => 'field_5294ba58ecbf2',
                'label' => 'Brand Color Change',
                'name' => 'brand_color_change',
                'type' => 'color_picker',
                'instructions' => 'Choose the brand color.',
                'default_value' => '',
            ),
            array (
                'key' => 'field_5294ba68ecbf3',
                'label' => 'Menu Position',
                'name' => 'menu_position',
                'type' => 'radio',
                'choices' => array (
                    'Bottom' => 'Bottom',
                    'Top' => 'Top',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => 'Bottom',
                'layout' => 'vertical',
            ),
            array (
                'key' => 'field_52989e7cd25ca',
                'label' => 'Animate Menu',
                'name' => 'animate_menu',
                'type' => 'radio',
                'instructions' => 'Choose if you need to animate menu.',
                'choices' => array (
                    'Once' => 'Once',
                    'Each Page' => 'Each Page',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => '',
                'layout' => 'vertical',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'options_page',
                    'operator' => '==',
                    'value' => 'acf-options-branding',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
            ),
        ),
        'menu_order' => 0,
    ));
    register_field_group(array (
        'id' => 'acf_clients',
        'title' => 'Clients',
        'fields' => array (
            array (
                'key' => 'field_5273ba357d399',
                'label' => 'Page Heading',
                'name' => 'page_heading',
                'type' => 'text',
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'formatting' => 'html',
                'maxlength' => '',
            ),
            array (
                'key' => 'field_5273ba3f7d39a',
                'label' => 'Clients',
                'name' => 'clients',
                'type' => 'repeater',
                'instructions' => 'Add as many clients as you want. Click "Add Client" to add a new client.',
                'sub_fields' => array (
                    array (
                        'key' => 'field_5273ba5b7d39b',
                        'label' => 'Client Logo',
                        'name' => 'client_logo',
                        'type' => 'image',
                        'column_width' => '',
                        'save_format' => 'object',
                        'preview_size' => 'thumbnail',
                        'library' => 'all',
                    ),
                    array (
                        'key' => 'field_5273ba897d39c',
                        'label' => 'Client URL',
                        'name' => 'client_url',
                        'type' => 'text',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                ),
                'row_min' => 0,
                'row_limit' => '',
                'layout' => 'table',
                'button_label' => 'Add Client',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-clients.php',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
                0 => 'the_content',
            ),
        ),
        'menu_order' => 0,
    ));
    register_field_group(array (
        'id' => 'acf_contact',
        'title' => 'Contact',
        'fields' => array (
            array (
                'key' => 'field_527b96e23e30d',
                'label' => 'Map',
                'name' => 'map',
                'type' => 'location-field',
                'val' => 'address',
                'center' => '48.856614,2.3522219000000177',
                'zoom' => 16,
                'scrollwheel' => 1,
            ),
            array (
                'key' => 'field_527b96ef3e30e',
                'label' => 'Map Zoom',
                'name' => 'map_zoom',
                'type' => 'number',
                'default_value' => 8,
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'min' => '',
                'max' => '',
                'step' => '',
            ),
            array (
                'key' => 'field_527b964d878fe',
                'label' => 'E-Mail ',
                'name' => 'e_mail_',
                'type' => 'text',
                'instructions' => 'Type the e-mail address where you want to accept contact form messages.',
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'formatting' => 'html',
                'maxlength' => '',
            ),
            array (
                'key' => 'field_527b9668878ff',
                'label' => 'Success Message',
                'name' => 'success_message',
                'type' => 'textarea',
                'instructions' => 'Success message which will appear when message is sent through contact form',
                'default_value' => '',
                'placeholder' => '',
                'maxlength' => '',
                'formatting' => 'html',
            ),
            array (
                'key' => 'field_527b968387900',
                'label' => 'Adress',
                'name' => 'adress',
                'type' => 'textarea',
                'instructions' => 'Type a contact note, or your address',
                'default_value' => '',
                'placeholder' => '',
                'maxlength' => '',
                'formatting' => 'html',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-contact.php',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
			array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-companypage.php',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
                0 => 'the_content',
            ),
        ),
        'menu_order' => 0,
    ));

    if(function_exists("register_field_group"))
    {
        register_field_group(array (
            'id' => 'acf_home',
            'title' => 'Home',
            'fields' => array (
                array (
                    'key' => 'field_528cd3015c1a6',
                    'label' => 'Slider or Video',
                    'name' => 'slider_or_video',
                    'type' => 'select',
                    'instructions' => 'Choose if you want a Slider or a fullscreen video.',
                    'choices' => array (
                        'Slider' => 'Slider',
                        'Video' => 'Video',
                    ),
                    'default_value' => '',
                    'allow_null' => 0,
                    'multiple' => 0,
                ),
                    array (
                        'key' => 'field_5267d6aa87096',
                        'label' => 'Slider',
                        'name' => 'slider',
                        'type' => 'repeater',
                        'instructions' => 'Click "Add Slide" to add a new slide.',
                        'conditional_logic' => array (
                            'status' => 1,
                            'rules' => array (
                                array (
                                    'field' => 'field_528cd3015c1a6', /*Dont forget this*/
                                    'operator' => '==',
                                    'value' => 'Slider',
                                ),
                            ),
                            'allorany' => 'all',
                        ),
                        'sub_fields' => array (
                            array (
                                'key' => 'field_545cda6e28bbf',
                                'label' => 'Media Type',
                                'name' => 'media_type',
                                'type' => 'radio',
                                'column_width' => '',
                                'choices' => array (
                                    'Image' => 'Image',
                                    'Video' => 'Video',
                                ),
                                'other_choice' => 0,
                                'save_other_choice' => 0,
                                'default_value' => 'Image',
                                'layout' => 'horizontal',
                            ),
                            array (
                                'key' => 'field_5267d6ed87097',
                                'label' => 'Image',
                                'name' => 'image',
                                'type' => 'image',
                                'conditional_logic' => array (
                                    'status' => 1,
                                    'rules' => array (
                                        array (
                                            'field' => 'field_545cda6e28bbf',
                                            'operator' => '==',
                                            'value' => 'Image',
                                        ),
                                    ),
                                    'allorany' => 'all',
                                ),
                                'column_width' => '',
                                'save_format' => 'url',
                                'preview_size' => 'thumbnail',
                                'library' => 'all',
                            ),
                            array (
                                'key' => 'field_545cda8928bc0',
                                'label' => 'Video Poster',
                                'name' => 'video_poster',
                                'type' => 'image',
                                'instructions' => 'Choose an image which will be shown on touch enabled devices, as Video cannot be played on touch enabled devices.',
                                'conditional_logic' => array (
                                    'status' => 1,
                                    'rules' => array (
                                        array (
                                            'field' => 'field_545cda6e28bbf',
                                            'operator' => '==',
                                            'value' => 'Video',
                                        ),
                                    ),
                                    'allorany' => 'all',
                                ),
                                'column_width' => '',
                                'save_format' => 'url',
                                'preview_size' => 'thumbnail',
                                'library' => 'all',
                            ),
                            array (
                                'key' => 'field_545cda2928bbe',
                                'label' => 'Video URL',
                                'name' => 'video_url',
                                'type' => 'text',
                                'instructions' => 'Place a video URL from Vimeo or Youtube',
                                'conditional_logic' => array (
                                    'status' => 1,
                                    'rules' => array (
                                        array (
                                            'field' => 'field_545cda6e28bbf',
                                            'operator' => '==',
                                            'value' => 'Video',
                                        ),
                                    ),
                                    'allorany' => 'all',
                                ),
                                'column_width' => '',
                                'default_value' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'formatting' => 'html',
                                'maxlength' => '',
                            ),
                            array (
                                'key' => 'field_545cdab728bc1',
                                'label' => 'Video MP4',
                                'name' => 'video_mp4',
                                'type' => 'file',
                                'instructions' => 'MP4 for Safari, IE9, iPhone, iPad, Android, and Windows Phone 7',
                                'conditional_logic' => array (
                                    'status' => 1,
                                    'rules' => array (
                                        array (
                                            'field' => 'field_545cda6e28bbf',
                                            'operator' => '==',
                                            'value' => 'Video',
                                        ),
                                    ),
                                    'allorany' => 'all',
                                ),
                                'column_width' => '',
                                'save_format' => 'url',
                                'library' => 'all',
                            ),
                            array (
                                'key' => 'field_545cdadd28bc2',
                                'label' => 'Video VP8',
                                'name' => 'video_vp8',
                                'type' => 'file',
                                'instructions' => 'WebM/VP8 for Firefox4, Opera, and Chrome',
                                'conditional_logic' => array (
                                    'status' => 1,
                                    'rules' => array (
                                        array (
                                            'field' => 'field_545cda6e28bbf',
                                            'operator' => '==',
                                            'value' => 'Video',
                                        ),
                                    ),
                                    'allorany' => 'all',
                                ),
                                'column_width' => '',
                                'save_format' => 'url',
                                'library' => 'all',
                            ),
                            array (
                                'key' => 'field_545cdaec28bc3',
                                'label' => 'Video OGG',
                                'name' => 'video_ogg',
                                'type' => 'file',
                                'instructions' => 'Ogg/Vorbis for older Firefox and Opera versions',
                                'conditional_logic' => array (
                                    'status' => 1,
                                    'rules' => array (
                                        array (
                                            'field' => 'field_545cda6e28bbf',
                                            'operator' => '==',
                                            'value' => 'Video',
                                        ),
                                    ),
                                    'allorany' => 'all',
                                ),
                                'column_width' => '',
                                'save_format' => 'url',
                                'library' => 'all',
                            ),
                            array (
                                'key' => 'field_545cdb0628bc4',
                                'label' => 'Video Volume',
                                'name' => 'video_volume',
                                'type' => 'number',
                                'conditional_logic' => array (
                                    'status' => 1,
                                    'rules' => array (
                                        array (
                                            'field' => 'field_545cda6e28bbf',
                                            'operator' => '==',
                                            'value' => 'Video',
                                        ),
                                    ),
                                    'allorany' => 'all',
                                ),
                                'column_width' => '',
                                'default_value' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'min' => '0.0',
                                'max' => '0.9',
                                'step' => '',
                            ),
                            array (
                                'key' => 'field_5267d6ff87098',
                                'label' => 'Label',
                                'name' => 'label',
                                'type' => 'textarea',
                                'column_width' => '',
                                'default_value' => '',
                                'placeholder' => '',
                                'maxlength' => '',
                                'formatting' => 'html',
                            ),
                            array (
                                'key' => 'field_527a46579f8cc',
                                'label' => 'Text Animation',
                                'name' => 'text_animation',
                                'type' => 'select',
                                'instructions' => 'Choose the text animation from the drop-down bellow',
                                'column_width' => 10,
                                'choices' => array (
                                    'flipInX' => 'flipInX',
                                    'flipInY' => 'flipInY',
                                    'fadeIn' => 'fadeIn',
                                    'fadeInUp' => 'fadeInUp',
                                    'fadeInDown' => 'fadeInDown',
                                    'fadeInLeft' => 'fadeInLeft',
                                    'fadeInRight' => 'fadeInRight',
                                    'slideInDown' => 'slideInDown',
                                    'bounceIn' => 'bounceIn',
                                    'bounceInDown' => 'bounceInDown',
                                    'rotateIn' => 'rotateIn',
                                    'rotateInDownLeft' => 'rotateInDownLeft',
                                    'rotateInDownRight' => 'rotateInDownRight',
                                    'rotateInUpLeft' => 'rotateInUpLeft',
                                    'rotateInUpRight' => 'rotateInUpRight',
                                    'lightSpeedIn' => 'lightSpeedIn',
                                    'rollIn' => 'rollIn',
                                ),
                                'default_value' => '',
                                'allow_null' => 0,
                                'multiple' => 0,
                            ),
                            array (
                                'key' => 'field_5267d72287099',
                                'label' => 'Button URL',
                                'name' => 'button_url',
                                'type' => 'text',
                                'column_width' => '',
                                'default_value' => '',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'formatting' => 'none',
                                'maxlength' => '',
                            ),
                            array (
                                'key' => 'field_5267d7348709a',
                                'label' => 'Button Text',
                                'name' => 'button_text',
                                'type' => 'text',
                                'column_width' => '',
                                'default_value' => 'View Project',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'formatting' => 'html',
                                'maxlength' => '',
                            ),
                            array (
                                'key' => 'field_527a47629f8cd',
                                'label' => 'Button & HTML Animation',
                                'name' => 'button_animation',
                                'type' => 'select',
                                'instructions' => 'Select button animation from the drop-down list bellow',
                                'column_width' => 10,
                                'choices' => array (
                                    'flipInX' => 'flipInX',
                                    'flipInY' => 'flipInY',
                                    'fadeIn' => 'fadeIn',
                                    'fadeInUp' => 'fadeInUp',
                                    'fadeInDown' => 'fadeInDown',
                                    'fadeInLeft' => 'fadeInLeft',
                                    'fadeInRight' => 'fadeInRight',
                                    'slideInDown' => 'slideInDown',
                                    'bounceIn' => 'bounceIn',
                                    'bounceInDown' => 'bounceInDown',
                                    'rotateIn' => 'rotateIn',
                                    'rotateInDownLeft' => 'rotateInDownLeft',
                                    'rotateInDownRight' => 'rotateInDownRight',
                                    'rotateInUpLeft' => 'rotateInUpLeft',
                                    'rotateInUpRight' => 'rotateInUpRight',
                                    'lightSpeedIn' => 'lightSpeedIn',
                                    'rollIn' => 'rollIn',
                                ),
                                'default_value' => '',
                                'allow_null' => 0,
                                'multiple' => 0,
                            ),
                            array (
                                'key' => 'field_5282543e01123',
                                'label' => 'Overlay Opacity',
                                'name' => 'overlay_opacity',
                                'type' => 'number',
                                'instructions' => 'Choose Overlay Opacity from 0.1 to 0.9',
                                'column_width' => 5,
                                'default_value' => '0.5',
                                'placeholder' => '',
                                'prepend' => '',
                                'append' => '',
                                'min' => '0.1',
                                'max' => '0.9',
                                'step' => '0.1',
                            ),
                            array (
                                'key' => 'field_52a980969d2d9',
                                'label' => 'Custom HTML',
                                'name' => 'custom_html',
                                'type' => 'textarea',
                                'instructions' => 'Insert custom HTML here, but this area is user selected and styling is also your responsibility.',
                                'column_width' => 20,
                                'default_value' => '',
                                'placeholder' => '',
                                'maxlength' => '',
                                'formatting' => 'html',
                            ),
                        ),
                        'row_min' => '',
                        'row_limit' => '',
                        'layout' => 'row',
                        'button_label' => 'Add Slide',
                    ),
                array (
                    'key' => 'field_527a733182975',
                    'label' => 'Autoplay',
                    'name' => 'autoplay',
                    'type' => 'radio',
                    'instructions' => 'Should slider auto-play slides or not.',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Slider',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'choices' => array (
                        'Disabled' => 'Disabled',
                        'Enabled' => 'Enabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_527a735714782',
                    'label' => 'Autoplay delay',
                    'name' => 'autoplay_delay',
                    'type' => 'number',
                    'instructions' => 'Delay between slides on miliseconds, works only if auto-play is enabled.',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_527a733182975',
                                'operator' => '==',
                                'value' => 'Enabled',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => 7999,
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => '',
                    'max' => '',
                    'step' => '',
                ),
                array (
                    'key' => 'field_527a739e56a3a',
                    'label' => 'Slider Animation',
                    'name' => 'slider_animation',
                    'type' => 'radio',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Slider',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'choices' => array (
                        'fade' => 'Fade',
                        'slide' => 'Slide',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_528254f198ee6',
                    'label' => 'Overlay Color',
                    'name' => 'overlay_color',
                    'type' => 'color_picker',
                    'instructions' => 'Choose the overlay color.',
                    'default_value' => '#000',
                ),
                array (
                    'key' => 'field_5270e6ef25898asdd123',
                    'label' => 'Video URL from Youtube or Vimeo',
                    'name' => 'video_url',
                    'type' => 'text',
                    'instructions' => 'If this field is filled than the Video file will be ignored',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_528f635294e9d',
                    'label' => 'Video Poster',
                    'name' => 'video_poster',
                    'type' => 'image',
                    'instructions' => 'Choose an image which will be shown on touch enabled devices, as Video cannot be played on touch enabled devices.',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'preview_size' => 'thumbnail',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_528cd4c2d1512',
                    'label' => 'Video MP4',
                    'name' => 'video_mp4',
                    'type' => 'file',
                    'instructions' => 'MP4 for Safari, IE9, iPhone, iPad, Android, and Windows Phone 7',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_5270e6ef25898mp4',
                    'label' => 'Video MP4 URL',
                    'name' => 'video_mp4_url',
                    'type' => 'text',
                    'instructions' => 'MP4 for Safari, IE9, iPhone, iPad, Android, and Windows Phone 7 (if you need to load video externally)',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_528cd4d9d1513',
                    'label' => 'Video VP8',
                    'name' => 'video_vp8',
                    'type' => 'file',
                    'instructions' => 'WebM/VP8 for Firefox4, Opera, and Chrome',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_5270e6ef25898vp8',
                    'label' => 'Video VP8 URL',
                    'name' => 'video_vp8_url',
                    'type' => 'text',
                    'instructions' => 'WebM/VP8 for Firefox4, Opera, and Chrome (if you need to load video externally)',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_528cd4f5d1514',
                    'label' => 'Video OGG',
                    'name' => 'video_ogg',
                    'type' => 'file',
                    'instructions' => 'Ogg/Vorbis for older Firefox and Opera versions',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_5270e6ef25898ogg',
                    'label' => 'Video OGG URL',
                    'name' => 'video_ogg_url',
                    'type' => 'text',
                    'instructions' => 'Ogg/Vorbis for older Firefox and Opera versions (if you need to load video externally)',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_528cd51b3b662',
                    'label' => 'Video Volume',
                    'name' => 'video_volume',
                    'type' => 'number',
                    'instructions' => 'Enter number volume from 0.0 to 0.9.',
                    'default_value' => '0.5',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => '0.0',
                    'max' => '0.9',
                    'step' => '0.1',
                ),
                array (
                    'key' => 'field_528e217893fac',
                    'label' => 'Label',
                    'name' => 'label',
                    'type' => 'textarea',
                    'instructions' => 'The centered big text label.',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'maxlength' => '',
                    'formatting' => 'br',
                ),
                array (
                    'key' => 'field_528e219293fad',
                    'label' => 'Button Text',
                    'name' => 'button_text',
                    'type' => 'text',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_528e21a493fae',
                    'label' => 'Button URL',
                    'name' => 'button_url',
                    'type' => 'text',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
            ),
            'location' => array (
                array (
                    array (
                        'param' => 'page_template',
                        'operator' => '==',
                        'value' => 'template-home.php',
                        'order_no' => 0,
                        'group_no' => 0,
                    ),
                ),
            ),
            'options' => array (
                'position' => 'normal',
                'layout' => 'default',
                'hide_on_screen' => array (
                    0 => 'the_content',
                ),
            ),
            'menu_order' => 0,
        ));
    };

    if(function_exists("register_field_group"))
    {
        register_field_group(array (
            'id' => 'acf_main',
            'title' => 'Main',
            'fields' => array (
				array (
                    'key' => 'field_5294b7e4e809dpurhasd',
                    'label' => 'Themeforest Purchase Key - AutoUpdate Theme',
                    'name' => 'purchase_key',
                    'type' => 'text',
                    'instructions' => 'Enter the purchase key from themeforest if you want to auto update Arctic',
                ),
                array (
                    'key' => 'field_5294b7e4e809d',
                    'label' => 'Custom CSS',
                    'name' => 'custom_css',
                    'type' => 'code_area',
                    'instructions' => 'Write Some CSS if you need on this field.',
                    'language' => 'css',
                    'theme' => 'ambiance',
                ),
                array (
                    'key' => 'field_5294b8864509e',
                    'label' => 'Custom JavaScript',
                    'name' => 'custom_javascript',
                    'type' => 'code_area',
                    'instructions' => 'Write Custom JavaScript on this field.If you need to write jQuery than you have to use jQuery instead of $.',
                    'language' => 'javascript',
                    'theme' => 'ambiance',
                ),
                array (
                    'key' => 'field_5294b8c89d7f4',
                    'label' => 'Ajax Site',
                    'name' => 'ajax_site',
                    'type' => 'radio',
                    'instructions' => 'Enable or Disable Ajax Site.',
                    'choices' => array (
                        'Enabled' => 'Enabled',
                        'Disabled' => 'Disabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Enabled',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_5294b8e39d7f5',
                    'label' => 'Smooth Scrolling',
                    'name' => 'smooth_scrolling',
                    'type' => 'radio',
                    'instructions' => 'Enable or Disable smooth scrolling.',
                    'choices' => array (
                        'Enabled' => 'Enabled',
                        'Disabled' => 'Disabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Enabled',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_5294b8fd9d7f6',
                    'label' => 'Post Likes',
                    'name' => 'post_likes',
                    'type' => 'radio',
                    'instructions' => 'Enable or disable post likes.',
                    'choices' => array (
                        'Enabled' => 'Enabled',
                        'Disabled' => 'Disabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Enabled',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_5294b8fd9d7bj',
                    'label' => 'Enable Footer',
                    'name' => 'enable_footer',
                    'type' => 'radio',
                    'instructions' => 'Enable or disable footer.',
                    'choices' => array (
                        'Enabled' => 'Enabled',
                        'Disabled' => 'Disabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Disabled',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_5294b93c9d7f7',
                    'label' => 'Google Analytic\'s Tracking Code',
                    'name' => 'google_analytics_tracking_code',
                    'type' => 'code_area',
                    'instructions' => 'Type the google analytic\'s tracking code.',
                    'language' => 'javascript',
                    'theme' => 'ambiance',
                ),
                array (
                    'key' => 'field_5294b9630b5b8',
                    'label' => 'Post Filter',
                    'name' => 'post_filter',
                    'type' => 'radio',
                    'instructions' => 'Choose the filter logic on Projects page.',
                    'choices' => array (
                        'Enabled' => 'Instant - With JavaScript',
                        'Disabled' => 'Category Redirect',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Instant - With JavaScript',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_52a08731954ac123',
                    'label' => 'Projects Page',
                    'name' => 'projects_page',
                    'type' => 'page_link',
                    'instructions' => 'Select from this drop down, the page where projects are listed, we need this to have the URL on the Back Button within the single portfolio page.',
                    'post_type' => array (
                        0 => 'page',
                    ),
                    'allow_null' => 0,
                    'multiple' => 0,
                ),
                array (
                    'key' => 'field_5294b8c89d7f4added',
                    'label' => 'Portfolio Category Page Layout',
                    'name' => 'portfolio_category_layout',
                    'type' => 'select',
                    'instructions' => 'Choose the portfolio category page layout',
                    'choices' => array (
                        'Grid' => 'Grid',
                        'Horizontal' => 'Horizontal',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Enabled',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_5294b8c89d7f4added1',
                    'label' => 'FancyBox Portfolio',
                    'name' => 'fancybox_portfolio',
                    'type' => 'select',
                    'instructions' => 'Enable or Disable Fancybox Portfolio',
                    'choices' => array (
                        'Disabled' => 'Disabled',
                        'Enabled' => 'Enabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Disabled',
                    'layout' => 'vertical',
                ),
				array (
                    'key' => 'field_5294b8c89d7f4blog_sidebar',
                    'label' => 'Blog Sidebar',
                    'name' => 'blog_sidebar',
                    'type' => 'radio',
                    'instructions' => 'Enable or Disable Sidebar on Blog Page',
                    'choices' => array (
                        'Disabled' => 'Disabled',
                        'Enabled' => 'Enabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Disabled',
                    'layout' => 'vertical',
                ),
				array (
                    'key' => 'field_5294b8c89d7f4pinpoins',
                    'label' => 'Allow HTML on Match Points',
                    'name' => 'allow_html_pin_points',
                    'type' => 'radio',
                    'instructions' => 'If you enable this feature than you have to re-insert each match point on projects',
                    'choices' => array (
                        'Disabled' => 'Disabled',
                        'Enabled' => 'Enabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Disabled',
                    'layout' => 'vertical',
                ),
				array (
                    'key' => 'field_5294b8c89d7f4single_post_sidebar',
                    'label' => 'Single Post Sidebar',
                    'name' => 'single_post_sidebar',
                    'type' => 'radio',
                    'instructions' => 'Enable or Disable Sidebar on Single Post Page',
                    'choices' => array (
                        'Disabled' => 'Disabled',
                        'Enabled' => 'Enabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Disabled',
                    'layout' => 'vertical',
                ),
            ),
            'location' => array (
                array (
                    array (
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => 'acf-options-main',
                        'order_no' => 0,
                        'group_no' => 0,
                    ),
                ),
            ),
            'options' => array (
                'position' => 'normal',
                'layout' => 'default',
                'hide_on_screen' => array (
                ),
            ),
            'menu_order' => 0,
        ));
    }

    if(function_exists("register_field_group"))
    {
        register_field_group(array (
            'id' => 'acf_portfolio',
            'title' => 'Portfolio',
            'fields' => array (
                array (
                    'key' => 'field_52a5bfb4d4984',
                    'label' => 'Slider or Video',
                    'name' => 'slider_or_video',
                    'type' => 'select',
                    'instructions' => 'Choose if you need a slider or video on this project.',
                    'choices' => array (
                        'Slider' => 'Slider',
                        'Video' => 'Video',
                    ),
                    'default_value' => 'Slider',
                    'allow_null' => 0,
                    'multiple' => 0,
                ),
                array (
                    'key' => 'field_526fae266c4be',
                    'label' => 'Slider',
                    'name' => 'slider',
                    'type' => 'repeater',
                    'instructions' => 'Add as many slides as you want.',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Slider',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'sub_fields' => array (
                        array (
                            'key' => 'field_526fae376c4bf',
                            'label' => 'Slide',
                            'name' => 'slide',
                            'type' => 'ui_drag',
                            'column_width' => '',
                        ),
                    ),
                    'row_min' => '',
                    'row_limit' => '',
                    'layout' => 'table',
                    'button_label' => 'Add Row',
                ),
                array (
                    'key' => 'field_5278fc4f775d7',
                    'label' => 'Link Button Text',
                    'name' => 'link_button_text',
                    'type' => 'text',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Slider',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_5278fc5d775d8',
                    'label' => 'Link Button URL',
                    'name' => 'link_button_url',
                    'type' => 'text',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Slider',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_52a5c0527f0c6',
                    'label' => 'Overlay Color',
                    'name' => 'overlay_color',
                    'type' => 'color_picker',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '#000',
                ),
                array (
                    'key' => 'field_52a5c0677f0c7',
                    'label' => 'Video Poster',
                    'name' => 'video_poster',
                    'type' => 'image',
                    'instructions' => 'Choose an image which will be shown on touch enabled devices, as Video cannot be played on touch enabled devices.',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'preview_size' => 'thumbnail',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_5270e6ef25898asdd',
                    'label' => 'Video URL from Youtube or Vimeo',
                    'name' => 'video_url',
                    'type' => 'text',
                    'instructions' => 'If this field is filled than the Video file will be ignored',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_52a5c0797f0c8',
                    'label' => 'Video MP4',
                    'name' => 'video_mp4',
                    'type' => 'file',
                    'instructions' => 'MP4 for Safari, IE9, iPhone, iPad, Android, and Windows Phone 7',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_5270e6ef25898mp41',
                    'label' => 'Video MP4 URL',
                    'name' => 'video_mp4_url',
                    'type' => 'text',
                    'instructions' => 'MP4 for Safari, IE9, iPhone, iPad, Android, and Windows Phone 7 (if you need to load video externally)',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_52a5c08c7f0c9',
                    'label' => 'Video VP8',
                    'name' => 'video_vp8',
                    'type' => 'file',
                    'instructions' => 'WebM/VP8 for Firefox4, Opera, and Chrome',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_5270e6ef25898vp81',
                    'label' => 'Video VP8 URL',
                    'name' => 'video_vp8_url',
                    'type' => 'text',
                    'instructions' => 'WebM/VP8 for Firefox4, Opera, and Chrome (if you need to load video externally)',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_52a5c09a7f0ca',
                    'label' => 'Video OGG',
                    'name' => 'video_ogg',
                    'type' => 'file',
                    'instructions' => 'Ogg/Vorbis for older Firefox and Opera versions',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'save_format' => 'url',
                    'library' => 'all',
                ),
                array (
                    'key' => 'field_5270e6ef25898ogg1',
                    'label' => 'Video OGG URL',
                    'name' => 'video_ogg_url',
                    'type' => 'text',
                    'instructions' => 'Ogg/Vorbis for older Firefox and Opera versions (if you need to load video externally)',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_528cd3015c1a6',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'formatting' => 'html',
                    'maxlength' => '',
                ),
                array (
                    'key' => 'field_52a5c0a97f0cb',
                    'label' => 'Video Volume',
                    'name' => 'video_volume',
                    'type' => 'number',
                    'instructions' => 'Enter number volume from 0.0 to 0.9.',
                    'conditional_logic' => array (
                        'status' => 1,
                        'rules' => array (
                            array (
                                'field' => 'field_52a5bfb4d4984',
                                'operator' => '==',
                                'value' => 'Video',
                            ),
                        ),
                        'allorany' => 'all',
                    ),
                    'default_value' => '0.5',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                    'min' => 0,
                    'max' => '0.9',
                    'step' => '',
                ),
				array (
                    'key' => 'field_528cd3015c1a6portrait',
                    'label' => 'Force Portrait',
                    'name' => 'force_portrait',
                    'type' => 'true_false',
                    'instructions' => 'Force Portarit Mode on this post, even if it is disabled on Options',
                    'default_value' => '',
                    'allow_null' => 0,
                    'multiple' => 0,
                ),
                array (
                    'key' => 'field_545ce34b441ce',
                    'label' => 'Sidebar State',
                    'name' => 'sidebar_state',
                    'type' => 'radio',
                    'choices' => array (
                        'Closed' => 'Closed',
                        'Open' => 'Open',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => '',
                    'layout' => 'vertical',
                ),
                array (
                    'key' => 'field_545cea8e873d4',
                    'label' => 'Display Thumbs On Sidebar',
                    'name' => 'display_thumbs_on_sidebar',
                    'type' => 'radio',
                    'choices' => array (
                        'Enabled' => 'Enabled',
                        'Disabled' => 'Disabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Disabled',
                    'layout' => 'horizontal',
                ),
                array (
                    'key' => 'field_545cedd6e016a',
                    'label' => 'Autoplay',
                    'name' => 'autoplay',
                    'type' => 'radio',
                    'choices' => array (
                        'Enabled' => 'Enabled',
                        'Disabled' => 'Disabled',
                    ),
                    'other_choice' => 0,
                    'save_other_choice' => 0,
                    'default_value' => 'Disabled',
                    'layout' => 'horizontal',
                ),
            ),
            'location' => array (
                array (
                    array (
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => 'portfolio',
                        'order_no' => 0,
                        'group_no' => 0,
                    ),
                ),
            ),
            'options' => array (
                'position' => 'normal',
                'layout' => 'default',
                'hide_on_screen' => array (
                ),
            ),
            'menu_order' => 0,
        ));
    }


    register_field_group(array (
        'id' => 'acf_projects',
        'title' => 'Projects',
        'fields' => array (
			array (
				'key' => 'field_52b060f99a2e9',
				'label' => 'Exclude Categories',
				'name' => 'exclude_categories',
				'type' => 'repeater',
				'instructions' => 'Exclude categories, click add row to add a Category to exclude.',
				'sub_fields' => array (
					array (
						'key' => 'field_52b061119a2ea',
						'label' => 'Category',
						'name' => 'category',
						'type' => 'taxonomy',
						'column_width' => '',
						'taxonomy' => 'portfolio_category',
						'field_type' => 'select',
						'allow_null' => 0,
						'load_save_terms' => 0,
						'return_format' => 'object',
						'multiple' => 0,
					),
				),
				'row_min' => 0,
				'row_limit' => '',
				'layout' => 'table',
				'button_label' => 'Add Row',
			),
            array (
                'key' => 'field_5270e6ef25898',
                'label' => 'Page Heading',
                'name' => 'page_heading',
                'type' => 'text',
                'instructions' => 'Type page heading on this field.',
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'formatting' => 'html',
                'maxlength' => '',
            ),
            array (
                'key' => 'field_5270e6fc25899',
                'label' => 'Number of projects per page',
                'name' => 'number_of_projects_per_page',
                'type' => 'number',
                'default_value' => 6,
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'min' => '',
                'max' => '',
                'step' => '',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-projects.php',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
            array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-projects-grid.php',
                    'order_no' => 0,
                    'group_no' => 1,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
                0 => 'the_content',
            ),
        ),
        'menu_order' => 0,
    ));
    register_field_group(array (
        'id' => 'acf_projects-single-page',
        'title' => 'Projects Single Page',
        'fields' => array (
            array (
                'key' => 'field_5294babb77ccc',
                'label' => 'Arrows on single Project Page',
                'name' => 'arrows_on_single_project_page',
                'type' => 'radio',
                'choices' => array (
                    'Enabled' => 'Enabled',
                    'Disabled' => 'Disabled',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => 'Enabled',
                'layout' => 'vertical',
            ),
            array (
                'key' => 'field_5294baca77ccd',
                'label' => 'Slider Animation',
                'name' => 'slider_animation',
                'type' => 'radio',
                'choices' => array (
                    'fade' => 'Fade',
                    'slide' => 'Slide',
                ),
                'other_choice' => 0,
                'save_other_choice' => 0,
                'default_value' => 'Fade',
                'layout' => 'vertical',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'options_page',
                    'operator' => '==',
                    'value' => 'acf-options-portfolio-single-page',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
            ),
        ),
        'menu_order' => 0,
    ));
    register_field_group(array (
        'id' => 'acf_services',
        'title' => 'Services',
        'fields' => array (
            array (
                'key' => 'field_5277cbf966d34',
                'label' => 'Services',
                'name' => 'services',
                'type' => 'repeater',
                'instructions' => 'Add as many services as you need from this field. Click add service to add a new one.',
                'sub_fields' => array (
                    array (
                        'key' => 'field_5277cc1366d35',
                        'label' => 'Service Title',
                        'name' => 'service_title',
                        'type' => 'text',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'html',
                        'maxlength' => '',
                    ),
                    array (
                        'key' => 'field_5277cc1e66d36',
                        'label' => 'Service URL',
                        'name' => 'service_url',
                        'type' => 'text',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'html',
                        'maxlength' => '',
                    ),
                    array (
                        'key' => 'field_5277cc2f66d37',
                        'label' => 'Service Description',
                        'name' => 'service_description',
                        'type' => 'textarea',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'maxlength' => '',
                        'formatting' => 'html',
                    ),
                    array (
                        'key' => 'field_5277cc3a66d38',
                        'label' => 'Service Image',
                        'name' => 'service_image',
                        'type' => 'image',
                        'column_width' => '',
                        'save_format' => 'object',
                        'preview_size' => 'thumbnail',
                        'library' => 'all',
                    ),
                ),
                'row_min' => 0,
                'row_limit' => '',
                'layout' => 'table',
                'button_label' => 'Add Service',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-services.php',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
                0 => 'the_content',
            ),
        ),
        'menu_order' => 0,
    ));
    register_field_group(array (
        'id' => 'acf_social-links',
        'title' => 'Social Links',
        'fields' => array (
            array (
                'key' => 'field_5273bcfa6e44d',
                'label' => 'Social Medias',
                'name' => 'social_medias',
                'type' => 'repeater',
                'instructions' => 'Add as many social medias as you want.Click Add Row to add a new social profile.',
                'sub_fields' => array (
                    array (
                        'key' => 'field_5273bd176e44e',
                        'label' => 'Social Profile',
                        'name' => 'social_profile',
                        'type' => 'select',
                        'column_width' => '',
                        'choices' => array (
                            'fa-dribbble' => 'Dribbble',
                            'fa-flickr' => 'Flickr',
                            'fa-stack-overflow' => 'Stack OverFlow',
                            'fa-youtube' => 'Youtube',
                            'fa-dropbox' => 'Dropbox',
                            'fa-instagram' => 'Instagram',
                            'fa-skype' => 'Skype',
                            'fa-tumblr' => 'Tumblr',
                            'fa-stack-exchange' => 'Stackexchange',
                            'fa-facebook' => 'Facebook',
                            'fa-twitter' => 'Twitter',
                            'fa-google-plus' => 'Google Plus',
                            'fa-pinterest' => 'Pinterest',
                            'fa-linkedin' => 'Linkedin',
                            'fa-vk' => 'VKF',
                            'fa-behance' => 'Behance',
                            'fa-deviantart' => 'Deviantart',
                            'fa-drupal' => 'Drupal',
                            'fa-hacker-news' => 'Hacker News',
                            'fa-jsfiddle' => 'JSfiddle',
                            'fa-reddit-square' => 'Reddit',
                            'fa-vimeo-square' => 'Vimeo',
                            'fa-android' => 'Android',
                            'fa-digg' => 'Digg',
                            'fa-github' => 'Github',
                            'fa-apple' => 'Apple',
                            'fa-steam' => 'Steam',
                            'fa-wordpress' => 'WordPress',
                            'fa-yahoo' => 'Yahoo',
                            'fa-delicious' => 'Delicious',
                            'fa-spotify' => 'Spotify',
                            'fa-soundcloud' => 'SoundCloud',
                            'fa-globe' => 'Website',
                            'fa-yelp' => 'Yelp',
                            'fa-houzz' => 'Houzz',
                        ),
                        'default_value' => '',
                        'allow_null' => 0,
                        'multiple' => 0,
                    ),
                    array (
                        'key' => 'field_5273bd236e44f',
                        'label' => 'Social URL',
                        'name' => 'social_url',
                        'type' => 'text',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'none',
                        'maxlength' => '',
                    ),
                ),
                'row_min' => 0,
                'row_limit' => '',
                'layout' => 'table',
                'button_label' => 'Add Row',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'options_page',
                    'operator' => '==',
                    'value' => 'acf-options-social',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
            ),
        ),
        'menu_order' => 0,
    ));
    register_field_group(array (
        'id' => 'acf_team',
        'title' => 'Team',
        'fields' => array (
            array (
                'key' => 'field_5273d55d5ae33',
                'label' => 'Page Heading',
                'name' => 'page_heading',
                'type' => 'text',
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'formatting' => 'html',
                'maxlength' => '',
            ),
			array (
                'key' => 'field_5273d55d5ae3312',
                'label' => 'Thumbnail Format',
                'name' => 'thumb_format',
                'type' => 'radio',
                'choices' => array(
					'Rounded' => 'Rounded',
					'Square' => 'Square',
				),
                'default_value' => '',
                'placeholder' => '',
                'prepend' => '',
                'append' => '',
                'formatting' => 'html',
                'maxlength' => '',
            ),
            array (
                'key' => 'field_5273d4fe26253',
                'label' => 'Team Members',
                'name' => 'team_members',
                'type' => 'repeater',
                'instructions' => 'Add as many team members as you need from this field.',
                'sub_fields' => array (
                    array (
                        'key' => 'field_5273d52026254',
                        'label' => 'Member Avatar',
                        'name' => 'member_avatar',
                        'type' => 'image',
                        'column_width' => '',
                        'save_format' => 'object',
                        'preview_size' => 'thumbnail',
                        'library' => 'all',
                    ),
                    array (
                        'key' => 'field_5273d52d26255',
                        'label' => 'Member Name',
                        'name' => 'member_name',
                        'type' => 'text',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'html',
                        'maxlength' => '',
                    ),
                    array (
                        'key' => 'field_5273d53826256',
                        'label' => 'Member Position',
                        'name' => 'member_position',
                        'type' => 'text',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'formatting' => 'html',
                        'maxlength' => '',
                    ),
                    array (
                        'key' => 'field_5273d53f26257',
                        'label' => 'Member Description',
                        'name' => 'member_description',
                        'type' => 'textarea',
                        'column_width' => '',
                        'default_value' => '',
                        'placeholder' => '',
                        'maxlength' => '',
                        'formatting' => 'html',
                    ),
                ),
                'row_min' => 0,
                'row_limit' => '',
                'layout' => 'table',
                'button_label' => 'Add Row',
            ),
        ),
        'location' => array (
            array (
                array (
                    'param' => 'page_template',
                    'operator' => '==',
                    'value' => 'template-team.php',
                    'order_no' => 0,
                    'group_no' => 0,
                ),
            ),
        ),
        'options' => array (
            'position' => 'normal',
            'layout' => 'default',
            'hide_on_screen' => array (
                0 => 'the_content',
            ),
        ),
        'menu_order' => 0,
    ));
}
?>