<?php
error_reporting(0);
if ( ! isset( $content_width ) ){ $content_width = 900; }
add_theme_support('post-thumbnails');
add_theme_support('automatic-feed-links');
add_theme_support('woocommerce');

/*Includes*/
define( 'ACF_LITE' , true );
include_once('acf/acf.php' );
include_once('includes/addons/acf-repeater/acf-repeater.php');
include_once('includes/addons/acf-flexible-content/acf-flexible-content.php');
include_once('includes/addons/acf-options-page/acf-options-page.php' );
require_once "shortcodes/shortcodes.php";
require_once "includes/aq_resizer.php";
require_once "includes/google-fonts.php";
require_once "includes/custom-fields.php";
require_once "includes/custom_walker.php";
require_once "includes/oneclick/wordpress-importer.php";
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
    require_once "includes/woocommerce-twitterbootstrap.php";
}
/*Includes*/

/*Globals*/
global $um_likes;
add_action("init","init_globals");
function init_globals(){
    global $um_likes;
    $um_likes = get_field("post_likes","options") != "Disabled" ? true : false;
}
/*Globals*/

/*Sidebar*/
function sidebar_widgets_init(){

    register_sidebar( array(
        'name' => __('Shop' , "um_lang"),
        'id' => 'shop',
        'description' => __( 'Shop' ,"um_lang" ),
        'before_widget' => '<div id="%1$s" class="um-about widget col-sm-12 %2$s">',
        'after_widget' => "</div>",
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ) );

    register_sidebar( array(
        'name' => __('Sidebar' , "um_lang"),
        'id' => 'sidebar',
        'description' => __( 'Sidebar' ,"um_lang" ),
        'before_widget' => '<div id="%1$s" class="um-about widget col-sm-12 %2$s">',
        'after_widget' => "</div>",
        'before_title' => '<h5 class="widget-title">',
        'after_title' => '</h5>',
    ) );

    register_sidebar( array(
        'name' => __('Footer' , "um_lang"),
        'id' => 'footer',
        'description' => __( 'Sidebar' ,"um_lang" ),
        'before_widget' => '<div id="%1$s" class="um_widget widget col-sm-4 %2$s">',
        'after_widget' => "</div>",
        'before_title' => '<div class="widget_title"><h5>',
        'after_title' => '</h5></div>',
    ) );
}

add_action( 'widgets_init', 'sidebar_widgets_init' );
/*Sidebar*/

/*Lang*/
add_action('after_setup_theme', 'my_theme_setup');
function my_theme_setup(){
    load_theme_textdomain('um_lang', get_template_directory() . '/lang');
}
/*Lang*/

/*Add Image Size*/
add_image_size("project_thumb",370,278,true);
add_image_size("member_thumb",470,470,true);
add_image_size("blog_post",568,336,true);
add_image_size("client_logo",400,258,false);
/*Add Image Size*/

/*Register Option Pages*/
if (function_exists("register_options_page")) {
    register_options_page('Main');
    register_options_page('Branding');
    register_options_page('Social');
    register_options_page('Portfolio Single Page');
}
/*Register Option Pages*/

/*Field Types*/
add_action('acf/register_fields', 'my_register_fields');
function my_register_fields(){
    include_once('includes/ui-drag/ui_drag-v4.php');
    include_once('includes/acf-location-field/location-v4.php');
    include_once('includes/advanced-custom-fields-code-area-field/acf_code_area-v4.php');
}
/*Field Types*/

/*Register Menu*/
add_action('init', 'register_my_menus');

function register_my_menus()
{
    register_nav_menus(
        array(
            'main_menu' => __('Main Menu', "um-lang"),
            'mobile_menu' => __('Mobile Menu', "um-lang")
        )
    );
}
/*Register Menu*/

/*Register Portfolio Post Types*/
add_action("init","my_post_types");
function my_post_types(){
    $rewrite = array();
    $rewrite["slug"] = "portfolio";
    $rewrite["with_front"] = true;

    register_post_type('portfolio',
        array(
            'labels' => array(
                'name' => __( "Portfolio" ,"um_lang"),
                'singular_name' => __( "Portfolios" , "um_lang" )
            ),
            'public' => true,
            'supports' => array('title','editor','thumbnail','comments','author'),
            'rewrite' => $rewrite
        )
    );

    register_taxonomy('portfolio_category',array (
        0 => 'portfolio',
    ),array( 'hierarchical' => true, 'label' => 'Portfolio Category','show_ui' => true,'query_var' => true,'singular_label' => 'Portfolio Category' , 'show_admin_column' => true) );

}
/*Register Portfolio Post Types*/

/*Get Likes*/
function get_likes($set = false,$postid = null){
    global $post;
    $post_id = $postid ? $postid : $post->ID;
    $views = get_post_meta($post_id, "umbrella_post_likes", true);
    if($set){
        $views = intval($views) + 1;
        if($views){
            update_post_meta($post_id, "umbrella_post_likes" , $views );
        }else{
            add_post_meta($post_id, "umbrella_post_likes" , 1 );
        }
    }
    return $views ? number_format($views, 0, ' ', ' ') : 0;
}
/*Get Likes*/

/*Like System*/
add_action('wp_ajax_um_like_post', 'um_like_post');
add_action('wp_ajax_nopriv_um_like_post', 'um_like_post');

function um_like_post(){
    $post_id = $_REQUEST["um_post_id"];
    echo get_likes(true,$post_id);
    wp_reset_postdata();
    die;
}
/*Like System*/

/*Enqueue Scripts And Styles*/
function enq_my_scripts(){
    /*Styles*/
    wp_enqueue_style("bootstrap", get_template_directory_uri() . "/assets/css/bootstrap.css", false, "1.0");
    wp_enqueue_style("media_element", get_template_directory_uri() . "/assets/mediaelement/mediaelementplayer.min.css", false, "1.0");
    wp_enqueue_style("superslides", get_template_directory_uri() . "/assets/css/superslides.css", false, "1.0");
	wp_enqueue_style("font_awesome", get_template_directory_uri() . "/assets/css/font-awesome.css", false, "1.0");
    wp_enqueue_style("animate", get_template_directory_uri() . "/assets/css/animate.css", false, "1.0");
    wp_enqueue_style("fancybox", get_template_directory_uri() . "/assets/fancybox/jquery.fancybox-1.3.4.css", false, "1.0");
    wp_enqueue_style("global_style", get_template_directory_uri() . "/assets/css/style.css", false, "1.0");
    if(get_field("skin_mode","options") == "Dark"){
        wp_enqueue_style("dark_skin", get_template_directory_uri() . "/assets/css/dark_skin.css", false, "1.0");
    }
    wp_enqueue_style("normal_drop_down_menu", get_template_directory_uri() . "/assets/css/dropdown_menu.css", false, "1.0");
    
	if(
        (function_exists("is_woocommerce") && is_woocommerce()) ||
        (function_exists("is_cart") && is_cart()) ||
        (function_exists("is_account_page") && is_account_page()) ||
        (basename(get_page_template()) == "page.php" && !is_tax()) ||
        (function_exists("is_checkout") && is_checkout())
    ){
        wp_enqueue_style("arctic_woocommerce_css", get_template_directory_uri() . "/assets/css/woocommerce.css", false, "1.0");
        if ( !in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ){
            wp_enqueue_style("woocommerce_css_no", get_template_directory_uri() . "/assets/css/woocommerce.css", false, "1.0");
        }
    }//wp_enqueue_style("arctic_woocommerce_css", get_template_directory_uri() . "/assets/css/woocommerce.css", false, "1.0");
	
    $font = get_field("google_fonts","options");
    if($font && $font != "--None--"){
        $font = $GLOBALS["UM_GOOGLEFONTS"][$font];
        $font_name = str_replace(" ","+",$font["family"]);
        $font_variants = "";
        $font_subset = "";
        if($font["variants"]){
            $font_variants = implode($font["variants"],",");
            $font_variants = ":".$font_variants;
        }
        if($font["subsets"]){
            $font_subset = implode($font["subsets"],",");
            $font_subset = "&subset=".$font_subset;
        }
        $font_url = "http://fonts.googleapis.com/css?family={$font_name}{$font_variants}{$font_subset}";
        wp_enqueue_style("google_fonts",$font_url,false);
        wp_enqueue_style("dynamic_css",get_template_directory_uri()."/assets/css/dynamic.php?font=".$font["family"],false);
    }else{
        wp_enqueue_style("google_font", "http://fonts.googleapis.com/css?family=Raleway:400,100,200,300,500,600,700,800,900", false, "1.0");
    }
    if(get_field("brand_color_change","options")){
        wp_enqueue_style("brand_color",get_template_directory_uri()."/assets/css/dynamic.php?brand_color=".urlencode(get_field("brand_color_change","options")),false);
    }
    wp_enqueue_style("default_style",get_stylesheet_uri(),false);
    /*Scripts*/
    wp_enqueue_script("jquery");
    wp_enqueue_script( 'comment-reply' );
    wp_enqueue_script( 'googl_maps',"https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false&ver=1",array(),1.0,true);
    wp_enqueue_script( 'jquery_ui',"http://ajax.googleapis.com/ajax/libs/jqueryui/1.10.2/jquery-ui.min.js",array(),1.0,true);
    wp_enqueue_script( 'animate_enhanced',get_template_directory_uri()."/assets/js/jquery.animate-enhanced.min.js",array(),1.0,true);
    wp_enqueue_script( 'respond',get_template_directory_uri()."/assets/js/respond.js",array(),1.0,true);
    wp_enqueue_script( 'fancybox',get_template_directory_uri()."/assets/fancybox/jquery.fancybox-1.3.4.pack.js",array(),1.0,true);
    wp_enqueue_script( 'modernizr',get_template_directory_uri()."/assets/js/moderniz.js",array(),1.0,false);
    wp_enqueue_script( 'wait_for_images',get_template_directory_uri()."/assets/js/jquery.waitforimages.js",array(),1.0,true);
    wp_enqueue_script( 'jquery_easing',get_template_directory_uri()."/assets/js/jquery.easing.min.js",array(),1.0,true);
    if(get_field("smooth_scrolling","options") != "Disabled"){
        wp_enqueue_script( 'smoothscroll',get_template_directory_uri()."/assets/js/jquery.smoothscroll.js",array(),1.0,true);
    }
    wp_enqueue_script( 'jquery_nice_scroll',get_template_directory_uri()."/assets/js/jquery.nicescroll.js",array(),1.0,true);
    wp_enqueue_script( 'media_element',get_template_directory_uri()."/assets/mediaelement/mediaelement-and-player.min.js",array(),1.0,true);
    wp_enqueue_script( 'superslides',get_template_directory_uri()."/assets/js/jquery.superslides.js",array(),1.0,true);
    wp_enqueue_script( 'mixitup',get_template_directory_uri()."/assets/js/jquery.mixitup.min.js",array(),1.0,true);
    wp_enqueue_script( 'waypoints',get_template_directory_uri()."/assets/js/waypoints.min.js",array(),1.0,true);
    wp_enqueue_script( 'swipe',get_template_directory_uri()."/assets/js/jquery.swipe.js",array(),1.0,true);
    wp_enqueue_script( 'imgliquid',get_template_directory_uri()."/assets/js/imgLiquid-min.js",array(),1.0,true);
    wp_enqueue_script("youtube_api", "http://www.youtube.com/iframe_api" ,array(),1.0,false);
    wp_enqueue_script( 'main_script',get_template_directory_uri()."/assets/js/script.js",array(),1.0,true);
}
add_action( 'wp_enqueue_scripts', 'enq_my_scripts' );
/*Enqueue Scripts And Styles*/

/*Documentation Option Page*/
add_action('admin_menu', 'register_my_custom_submenu_page' , 99);

function register_my_custom_submenu_page() {
    add_submenu_page( 'acf-options-main', 'Documentation', 'Documentation', 'manage_options', 'admin.php?page=acf-options-documentation', 'my_documentation_menu_callback' );
}

function my_documentation_menu_callback(){
    ?>
    <div class="icon32" id="fa fa-options-general"><br></div>
    <h2><?php _e("Documentation","um_lang"); ?></h2>
    <iframe width="100%" height="800px" src="http://documentation.umbrella.al/arctic-documentation/" frameborder="0"></iframe>
<?php
}
/*Documentation Option Page*/

/*WooCommerce*/
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
add_action('woocommerce_before_main_content', 'my_theme_wrapper_start', 10);
add_action('woocommerce_after_main_content', 'my_theme_wrapper_end', 10);

function my_theme_wrapper_start() {
    echo '<div id="um_container" class="col-md-9">';
}

function my_theme_wrapper_end() {
    echo '</div>';
}
/*WooCommerce*/

/*Vieo Embed*/
function getVideoEmbed($vurl){
    $image_url = parse_url($vurl);
    // Test if the link is for youtube
    if($image_url['host'] == 'www.youtube.com' || $image_url['host'] == 'youtube.com'){
        $array = explode("&", $image_url['query']);
        return '<iframe class="youtube" src="http://www.youtube.com/embed/' . substr($array[0], 2) . '?wmode=transparent&enablejsapi=1&loop=1&hd=1&vq=hd1080&version=3&playlist='. substr($array[0], 2) .'" width="100%" height="100%" frameborder="0" allowfullscreen></iframe>'; // Returns the youtube iframe embed code
        // Test if the link is for the shortened youtube share link
    } else if($image_url['host'] == 'www.youtu.be' || $image_url['host'] == 'youtu.be'){
        $array = ltrim($image_url['path'],'/');
        return '<iframe class="youtube" src="http://www.youtube.com/embed/' . $array . '?wmode=transparent&enablejsapi=1&loop=1&hd=1&vq=hd1080&version=3&playlist='. $array .'" width="100%" height="100%" frameborder="0" allowfullscreen></iframe>'; // Returns the youtube iframe embed code
        // Test if the link is for vimeo
    } else if($image_url['host'] == 'www.vimeo.com' || $image_url['host'] == 'vimeo.com'){
        $hash = substr($image_url['path'], 1);
        return '<iframe class="vimeo" src="http://player.vimeo.com/video/' . $hash . '?title=0&byline=0&portrait=0&api=1&loop=1" width="100%" height="100%" frameborder="0" webkitAllowFullScreen allowfullscreen></iframe>'; // Returns the vimeo iframe embed code
    }
}
/*Vieo Embed*/

/*Auto Theme Updates*/
global $api_url;
$api_url = 'http://themes.umbrella.al/themes/';
if(function_exists('wp_get_theme')){
    $theme_data = wp_get_theme(get_option('template'));
    $theme_version = $theme_data->Version;  
} else {
    $theme_data = get_theme_data( TEMPLATEPATH . '/style.css');
    $theme_version = $theme_data['Version'];
}    
$theme_base = get_option('template');
global $purchase_key;
$purchase_key = "";
if(function_exists("get_field")){
	$purchase_key = get_field("purchase_key","options");
}
add_filter('pre_set_site_transient_update_themes', 'check_for_update');

function check_for_update($checked_data) {
	global $wp_version, $theme_version, $theme_base, $api_url , $purchase_key;

	$request = array(
		'slug' => $theme_base,
		'version' => $theme_version 
	);
	// Start checking for an update
	$send_for_check = array(
		'body' => array(
			'action' => 'theme_update', 
			'request' => serialize($request),
			'api-key' => md5(get_bloginfo('url')),
			'purchase_key' => $purchase_key
		),
		'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
	);
	$raw_response = wp_remote_post($api_url, $send_for_check);

	if (!is_wp_error($raw_response) && ($raw_response['response']['code'] == 200))
		$response = unserialize($raw_response['body']);

	// Feed the update data into WP updater
	if (!empty($response)) 
		$checked_data->response[$theme_base] = $response;
	return $checked_data;
}

// Take over the Theme info screen on WP multisite
add_filter('themes_api', 'my_theme_api_call', 10, 3);

function my_theme_api_call($def, $action, $args) {
	global $theme_base, $api_url, $theme_version, $api_url;

	if ($args->slug != $theme_base)
		return false;

	// Get the current version

	$args->version = $theme_version;
	$request_string = prepare_request($action, $args);
	$request = wp_remote_post($api_url, $request_string);

	if (is_wp_error($request)) {
		$res = new WP_Error('themes_api_failed', __('An Unexpected HTTP Error occurred during the API request.</p> <p><a href="?" onclick="document.location.reload(); return false;">Try again</a>'), $request->get_error_message());
	} else {
		$res = unserialize($request['body']);

		if ($res === false)
			$res = new WP_Error('themes_api_failed', __('An unknown error occurred'), $request['body']);
	}

	return $res;
}

if (is_admin())
	$current = get_transient('update_themes');
/*Auto Theme Updates*/

function woo_related_products_limit() {
  global $product;
	
	$args = array(
		'post_type'        		=> 'product',
		'no_found_rows'    		=> 1,
		'posts_per_page'   		=> 3,
		'ignore_sticky_posts' 	=> 1,
		'orderby'             	=> $orderby,
		'post__in'            	=> $related,
		'post__not_in'        	=> array($product->id)
	);
	return $args;
}
add_filter( 'woocommerce_related_products_args', 'woo_related_products_limit' );