/*Globals*/
var history_count = 0;
var setup_fancy_box = function(){
    jQuery("div.fancybox_container").each(function(){
        var project_id = jQuery(this).data("project");
		if(project_id){
			jQuery("a[rel=gallery-"+project_id+"]").fancybox();
		}
    });
};
/*Globals*/

var calc_slider_width = function(){

    if(jQuery(".project_list_holder").length){
        var slider_margin = jQuery(".project_list_holder").offset().left;
        var window_width = jQuery(window).width();
        jQuery(".project_list_holder").css("width",window_width - parseInt(slider_margin));
    }
};

jQuery(window).load(function(){
	calc_slider_width();
    hide_loader();
    jQuery(".main_nav").addClass("animated");
});

jQuery(window).resize(function(){
	calc_slider_width();
});
	
jQuery(document).ready(function($){

    /*Implement Fancybox Function*/
    if(fancybox_enabled){
        $("body").on("click","div.post_thumb a , a.project_title",function(e){
            e.preventDefault();
            e.stopPropagation();
            $(this).parent().parent().find("div.fancybox_container a:eq(0)").trigger("click");
            $(this).parent().find("div.fancybox_container a:eq(0)").trigger("click");
        });
    }
    /*Implement Fancybox Function*/

    /*Menu Hover Sub Menu*/
    if(is_complex_menu){
        $("ul.main_menu > li.menu-item-has-children").mouseenter(function(){
            $("ul.sub-menu").hide();
            $(this).find("ul.sub-menu").eq(0).show();
            if($(this).find("ul.sub-menu").eq(0).length){
                $(".sub_holder_js").show();
            }
        });

        $("ul.sub-menu").mouseleave(function(){
            $("ul.sub-menu").hide();
            $(".sub_holder_js").hide();
        });
    }
    /*Menu Hover Sub Menu*/

    /*Ajax Navigation*/
    $("body").on("click","ul.main_menu a",function(e){
        if($(this).attr("target") || !ajax_site || $(this).attr("href") == "#" || $(this).parent().hasClass("menu-item-language")){
            return true;
        }
        if(animate_menu){
            $(".main_nav").removeClass("animated");
        }
        e.preventDefault();
        var url = jQuery(this).attr("href");
        var this_item = $(this);
        $.post(url, { um_ajax_load_site: true }, function (data) {
            changeURL(url);
            //get_body_class(url);
            history_count = 1;
            $("li.current-menu-item").removeClass("current-menu-item");
            this_item.parent().addClass("current-menu-item");
            $("div.inner_content").html(data);
            $('.responsive_menu').hide();
            if(animate_menu){
                $(".main_nav").addClass("animated");
            }
            scrollOnTop();
        }).error(function () {
            window.location = url;
        });
    });

    var ajax_button_selectors = [
        "div.capture a",
        "div.categories_inside a",
        "div.categories_inside a",
        "a.blog_title",
        "a[rel='tag']"
    ];
    if(!fancybox_enabled){
        ajax_button_selectors.push("div.post_thumb a");
        ajax_button_selectors.push("a.project_title");
    }
    $("body").on("click",ajax_button_selectors.toString(),function(e){
        if($(this).attr("target") || !ajax_site || $(this).attr("href") == "#"){
            return true;
        }
        e.preventDefault();
        var url = $(this).attr("href");
        load_data(url);
    });
    /*Ajax Navigation*/

    /*Add Sub Menu Top Class*/
    if(menu_location){
        $("div#menu").find("ul.sub-menu").addClass("submenu_top");
    }
    /*Add Sub Menu Top Class*/

    /*Single Portfolio Tooltips*/
    $("body").on("click","a.dot_small_info",function(e){
        e.preventDefault();
        var desc_container = $(this).next();
        var is_visible = desc_container.hasClass("fadeInRight");
        $('.dot_info_box').removeClass("fadeInRight");
        $('.dot_info_box').addClass("fadeOutRight");
        $('.scroll').getNiceScroll().hide();
        if(!is_visible){
            $(this).next().removeClass("fadeOutRight");
            $(this).next().addClass("fadeInRight");
			$(window).trigger("resize");
            $(this).next().children(".scroll").getNiceScroll().resize();
            $(this).next().children(".scroll").getNiceScroll().show();
			$('#slides').superslides('stop');
        }
        else{
            $(this).next().addClass("fadeOutRight");
            $(this).next().removeClass("fadeInRight");
			$('#slides').superslides('start');
        }
    });
	
	$(document).click(function(e){
		if ( $(e.target).parents('.dot_info').length === 0 ) {
			$(".dot_info_box.fadeInRight").parent().find("a").trigger("click");
		}
	});
    /*Single Portfolio Tooltips*/

    /*Projects Load More*/
    $("body").on("click",".load_more_projects_horizontal a",function(e){
        e.preventDefault();
        project_page++;
        var ajax_data = {
            um_paged : project_page,
            um_page : true,
            paged : project_page
        };
        var this_element = $(this);
        $.post(document.URL,ajax_data,function(data){
            if(data){
                this_element.parent().before(data);
                $('.project_list_holder ul').css("width",$('.project_list_holder ul li').length * ($('.project_list_holder ul li:eq(0)').width() + 24));
                $('.scroll').niceScroll();
                $('.project_list_holder ul').mixitup('remix');
                if(cat_filter){
                    $('.project_list_holder ul').mixitup("filter",cat_filter);
                }else{
                    $('.project_list_holder ul').mixitup("filter","mix_all");
                }
                calc_slider_width();
                setup_fancy_box();
            }else{
                this_element.parent().fadeOut();
            }
        }).error(function(){
                this_element.parent().fadeOut();
        });
    });

    $("body").on("click",".load_more_grid a",function(e){
        e.preventDefault();
        project_page++;
        var ajax_data = {
            um_paged : project_page,
            um_page : true,
            paged : project_page
        };
        var this_element = $(this);
        $.post(document.URL,ajax_data,function(data){
            if(data){
                $('.list_projects_grid').append(data);
                $('.list_projects_grid').mixitup('remix');
                if(cat_filter){
                    $('.list_projects_grid').mixitup("filter",cat_filter);
                }else{
                    $('.list_projects_grid').mixitup("filter","mix_all");
                }
                setup_fancy_box();
            }else{
                this_element.parent().fadeOut();
            }
        }).error(function(){
                this_element.parent().fadeOut();
        });
    });

    $("body").on("click",".load_more_grid_blog a",function(e){
        e.preventDefault();
        project_page++;
        var ajax_data = {
            paged : project_page,
            um_page : true
        };
        var this_element = $(this);
        $.post(document.URL,ajax_data,function(data){
            if(data){
                $('div.blog').append(data);
            }else{
                this_element.parent().fadeOut();
            }
        }).error(function(){
                this_element.parent().fadeOut();
        });
    });
    /*Projects Load More*/

    /*Project Filter*/
    var cat_filter = "";
    $("body").on("click",".mixitup a",function(e){
        if(is_instant_filter_mode){
            e.preventDefault();
            cat_filter = jQuery(this).data("filter");
            $("div.categories-p a.active").removeClass("active");
            $(this).addClass("active");
            $(".project_list_holder ul").mixitup("filter",cat_filter);
            $(".list_projects_grid").mixitup("filter",cat_filter);
        }
    });
    /*Project Filter*/

    /*Team Slider*/
    $(document).on("click",".team_nav a.next",function(e){
        e.preventDefault();
        var cur_slide = $("ul.team_members > li:visible");
        var next_slide = cur_slide.next().length ? cur_slide.next() : $("ul.team_members > li:eq(0)");
        cur_slide.stop(true,true).fadeOut("fast",function(){
            next_slide.stop(true,true).fadeIn("fast");
            $("ul.team_members > li div.member").removeClass("fadeInLeft");
            next_slide.find("div.member").addClass("fadeInLeft");
        });
    });

    $(document).on("click",".team_nav a.prev",function(e){
        e.preventDefault();
        var cur_slide = $("ul.team_members > li:visible");
        var next_slide = cur_slide.prev().length ? cur_slide.prev() : $("ul.team_members > li:last");
        cur_slide.stop(true,true).fadeOut("fast",function(){
            next_slide.stop(true,true).fadeIn("fast");
            $("ul.team_members > li div.member").removeClass("fadeInLeft");
            next_slide.find("div.member").addClass("fadeInLeft");
        });
    });
    /*Team Slider*/

    /*Facebook and Twitter Share*/
    $(document).on("click", "a.facebook_share",function (e) {
        e.preventDefault();
        var url = $(this).attr("href");
        window.open("http://www.facebook.com/share.php?u=" + url, "Facebook_Share", "menubar=1,resizable=1,width=900,height=500");
    });

    $(document).on("click", "a.twitter_share",function (e) {
        e.preventDefault();
        var url = $(this).attr("href");
        window.open("https://twitter.com/share?url=" + url, "Tweet", "menubar=1,resizable=1,width=900,height=500");
    });
    /*Facebook and Twitter Share*/

    /*Like System*/
    $("body").on("click","a.like",function(e){
        e.preventDefault();
        var postid = $(this).data("postid");
        if(!getCookie("um_liked_"+postid)){
            var this_anchor = $(this);
            var ajax_data = {
                um_post_id : postid,
                action : "um_like_post"
            };
            $.post(um_ajaxurl,ajax_data,function(data){
                this_anchor.find("p").text(data);
                this_anchor.addClass("liked");
                setCookie("um_liked_"+postid,"true",365);
            });
        }
    });
    /*Like System*/

    $(document).on("click",".project_info_js",function(e){
        e.preventDefault();
		if($("#project_info").length){
			var project_info_width = $("#project_info").width();
			if($("#project_info").position().left != 0){
				$("#project_info").stop(true,true).animate({left: 0 + 'px' }, 'fast',function(){
					$('.pr_info_holder').getNiceScroll().remove();
					$('.pr_info_holder').niceScroll();
				});
			}else{
				$("#project_info").stop(true,true).animate({left: -(project_info_width) + 'px' }, 'fast',function(){
					$('.pr_info_holder').getNiceScroll().remove();
				});
			}
		}
    });
	
	$(window).resize(function(){
		if($("#project_info").length){
			if($("#project_info").position().left != 0){
				var project_info_width = $("#project_info").width();
				$("#project_info").css({left: -(project_info_width) + 'px' });
			}
		}
	});
	
    var duration = 20;
    var delay = duration;
    var set_social_classes = null;
    var should_add_class = false;
    /*Show And Hide Social Icons*/
    $("body").on("mouseenter","div.social_js",function(){
        delay = duration;
        should_add_class = true;
        $("a.social_network").each(function(){
            var this_object = $(this);
            set_social_classes = setTimeout(function(){
                if(should_add_class){
                    this_object.removeClass("fadeOutDown");
                    this_object.addClass("fadeInUp");
                }
            },delay);
            delay += duration;
        });
    });

    $("body").on("mouseleave","div.social_js",function(){
        should_add_class = false;
        //$("a.social_network").removeClass("animated");
        delay = duration;
        $("a.social_network").each(function(){
            var this_object = $(this);
            set_social_classes = setTimeout(function(){
                this_object.addClass("fadeOutDown");
                this_object.removeClass("fadeInUp");
            },delay);
            delay += duration;
        });
    });
    /*Show And Hide Social Icons*/

    /*Contact Form*/
    $("body").on("submit","form.contact_form",function(){
        var name = $(this).find("#name");
        var email = $(this).find("#email");
        var message = $(this).find("#message");
        var url = $(this).attr("action");
        var return_state = true;
        var form = $(this);
        if(name.val() == ""){
            name.addClass("error");
            return_state = false;
        }
        if(email.val() == "" || !validateEmail(email.val())){
            email.addClass("error");
            return_state = false;
        }
        if(message.val() == ""){
            message.addClass("error");
            return_state = false;
        }		
        if(return_state){
			if($(this).hasClass("captcha")){
				return true;
			}
            var data = {
                um_name : name.val(),
                um_email : email.val(),
                um_message : message.val()
            }
            $.post(url,data,function(data){
                form.fadeOut("normal",function(){
                    form.next(".success-message").fadeIn("normal");
                });
            });
        }
        return false;
    });

    $("body").on("click","form.contact_form input, form.contact_form textarea",function(){
        $(this).removeClass();
    });
    /*Contact Form*/

    /*Shortcodes*/

    /*Accordions*/

    $("body").on("click","ul.accordion li > a",function(e){
        e.preventDefault();
        var parent = $(this).closest("ul.accordion");
        var this_element = $(this);
        parent.find("a.active").removeClass("active").find('i').addClass('fa-plus').removeClass('fa-minus').parent().siblings(".section_content").stop(true,true).slideUp({
            duration : 200 ,
            easing:"easeOutSine",
            complete : function(){
                this_element.addClass("active").find('i').removeClass('fa-plus').addClass('fa-minus').parent().siblings(".section_content").stop(true,true).slideDown({
                    easing : "easeInSine"
                });
            }
        });
    });

    /*Tabs*/

    $("body").on("click","div.tabs ul.tab_buttons li > a",function(e){
        e.preventDefault();
        var parent = $(this).parent().parent();
        var this_index = $(this).parent().index();
        parent.find("a").removeClass("active");
        $(this).addClass("active");
        parent.next().children("li").stop(true,true).fadeOut({
            easing : "easeOutSine",
            duration : 200 ,
            complete : function(){
                parent.next().children("li").eq(this_index).stop(true,true).fadeIn({
                    easing : "easeInSine",
                    duration : 200
                });
            }
        });
    });

    /*Toggles*/
    $("body").on("click",".toggle li > a",function(e){
        e.preventDefault();
        var section_content = $(this).siblings(".section_content");
        if($(this).hasClass("active")){
            $(this).removeClass("active").find('i').addClass('fa-plus').removeClass('fa-minus');
        }else{
            $(this).addClass("active").find('i').removeClass('fa-plus').addClass('fa-minus');
        }
        section_content.stop(true,true).slideToggle({
            easing : "easeInOutSine",
            duration : 200
        });
    });

    $("body").on("click","div.alert_container a.close",function(e){
        e.preventDefault();
        $(this).parent().fadeOut({
            duration : 800,
            easing : "easeOutSine"
        });
    });
    /*Alerts*/

    /*Shortcodes*/
    var biggerHeight = 0;
    var currentHeight = 0;
    var subMargin = 41;

    $('.sub-menu').each(function(){
        currentHeight = $(this).height();
        if(currentHeight > biggerHeight) {
            biggerHeight = currentHeight;
        }
    });

    $('.sub_holder').css('height', biggerHeight + 2 * subMargin);
	
	$('.responsive_menu').stop(true,true).hide();
    $('.menuBtn').click(function(){
        $('.responsive_menu').stop(true,true).fadeToggle();
    });

    $(window).resize(function(){
        if(!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) ) {
            $('.responsive_menu').hide();
        }
    });
});

/*Functions*/
function validateEmail(email) {
    var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(email);
}

function setCookie(c_name,value,exdays){
    var exdate=new Date();
    exdate.setDate(exdate.getDate() + exdays);
    var c_value=escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
    document.cookie=c_name + "=" + c_value;
}

function getCookie(c_name){
    var c_value = document.cookie;
    var c_start = c_value.indexOf(" " + c_name + "=");
    if (c_start == -1)
    {
        c_start = c_value.indexOf(c_name + "=");
    }
    if (c_start == -1)
    {
        c_value = null;
    }
    else
    {
        c_start = c_value.indexOf("=", c_start) + 1;
        var c_end = c_value.indexOf(";", c_start);
        if (c_end == -1)
        {
            c_end = c_value.length;
        }
        c_value = unescape(c_value.substring(c_start,c_end));
    }
    return c_value;
}

jQuery.fn.equals = function(compareTo) {
    if (!compareTo || this.length != compareTo.length) {
        return false;
    }
    for (var i = 0; i < this.length; ++i) {
        if (this[i] !== compareTo[i]) {
            return false;
        }
    }
    return true;
};

function show_loader(){
    jQuery(".loader").stop(true,true).fadeIn("fast");
}

function hide_loader(){
    jQuery(".loader").stop(true,true).fadeOut("fast");
}
/*Functions*/

/*Ajax Navigation*/
function changeURL(path){
    if (typeof(window.history.pushState) == 'function') {
        window.history.pushState(null, path, path);
        jQuery('.scroll').getNiceScroll().hide();
        jQuery('.scroll_projects').getNiceScroll().hide();
    }else{
        window.location.hash = '#!' + path;
    }
}

function load_data(url){
    show_loader();
    jQuery.get(url, { um_ajax_load_site: true }, function (data) {
        changeURL(url);
        //hide_loader();
        jQuery("div.inner_content").html(data);
        history_count = 1;
        scrollOnTop();
    }).error(function () {
        window.location = url;
    });
}

window.onpopstate = function (event) {
    if (history_count) {
        load_data(document.URL);
    }
};

function scrollOnTop(){
    jQuery("html, body").animate({ scrollTop: "0px" });
}

//IF - If hash is included than redirect to
if(window.location.hash != ''){
    var hash = window.location.hash;
    hash = hash.replace('#!', " ")
    window.location = hash;
}

jQuery(document).ajaxSend(function(event, jqxhr, settings) {
    show_loader();
}).ajaxComplete(function(event, jqxhr, settings) {
    jQuery(".inner_content").waitForImages(function(){
        hide_loader();
    });
})
/*Ajax Navigation*/

/*Youtube and Vimeo API Functions*/
function pasueVimeo(parent,player){
    pauseAllVimeos(parent);
    var volume = parseFloat(player.data("video-volume"));
    player = player.find("iframe.vimeo").get(0);
    if (player){
        player = player.contentWindow;
        player.postMessage('{"method":"play"}', '*');
        player.postMessage('{"method":"setVolume","value":'+volume+'}', '*');
    }
}

function pasueYoutube(parent,player) {
    pauseAllYoutubes(parent);
    var volume = parseFloat(player.data("video-volume")) * 100;
    player = player.find("iframe.youtube").get(0);
    if (player) {
        player = player.contentWindow;
        var func = "playVideo";
        player.postMessage('{"event":"command","func":"' + func + '","args":""}', '*');
        player.postMessage('{"event":"command","func":"' + "setVolume" + '","args":['+volume+']}', '*');
    }
}

function pauseAllYoutubes(parent) {
    var youtube_players = jQuery(parent).find("iframe.youtube");
    for (var i = 0; i < youtube_players.length; i++) {
        var youtube_player = youtube_players[i];
        youtube_player = youtube_player.contentWindow;
        var func = "pauseVideo";
        youtube_player.postMessage('{"event":"command","func":"' + func + '","args":""}', '*');
    }
}

function pauseAllVimeos(parent) {
    var youtube_players = jQuery(parent).find("iframe.vimeo");
    for (var i = 0; i < youtube_players.length; i++) {
        var youtube_player = youtube_players[i];
        youtube_player = youtube_player.contentWindow;
        youtube_player.postMessage('{"method":"pause"}', '*');
    }
}

function center_video(el){
    var playerBox = el;
    var win = {};
    var el = jQuery(window);

    win.width = el.width();
    win.height = el.height();

    var margin = 24;
    var vid = {};
    vid.width = win.width + ((win.width * margin) / 100);
    vid.height = Math.ceil((9 * win.width) / 16);
    vid.marginTop = -((vid.height - win.height) / 2);
    vid.marginLeft = -((win.width * (margin / 2)) / 100);

    if (vid.height < win.height) {
        vid.height = win.height + ((win.height * margin) / 100);
        vid.width = Math.floor((16 * win.height) / 9);
        vid.marginTop = -((win.height * (margin / 2)) / 100);
        vid.marginLeft = -((vid.width - win.width) / 2);
    }
    playerBox.css({width: vid.width, height: vid.height, marginTop: vid.marginTop, marginLeft: vid.marginLeft});
}
/*Youtube and Vimeo API Functions*/











