<?php
    defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
?>
<div id="info-details" style="display: none;">
    <div class="title-info-details">
        <?php lang::get("Link anchors explanation"); ?> 
    </div>
    <hr>
    <div class="content-info-details">
        <?php lang::get("Words and phrases, which will be used for an automatic linking between texts in corresponding category.");?>
        <br />
        <?php lang::get("Also, you can use a roots of the words, that you want to use for linking. The plugin will find the word with corresponding roots automatically and will use their words for link creating.");?>
    </div>
    <div class="button-close">
        <input type="button" value="<?php lang::get('Close');?>" class="lp-button-close" onclick="jQuery('#info-details').arcticmodal('close');">
    </div>
</div>

<div class="wrap">
    <form action="" method="post">
        <div class="main-form-setting">
            <div class="title-setting" onclick="shows_form('.setting-linking', '#icon-title');">
                <?php lang::get('Settings')?>
                <span id="icon-title" class="dashicons dashicons-arrow-down"></span>
            </div>
            <div class="setting-linking" style="display: none;">
                <table class="form-table">
                    <tr>
                        <th>
                        <label for="count-links"><?php lang::get('Count of links in text')?></label>
                        <br />
                        <span style="font-size: 12px; font-weight: 300;">(<?php lang::get('Links won\'t be created if the word roots or words or phrases wasn\'t found' )?>)</span>
                        </th>
                        <td><input type="text" name="count_links" id="count-links" value="<?php echo $link_count; ?>"></td>
                    </tr>
                    <tr>
                        <th>
                            <label for="black-words"><?php lang::get('Black Words')?></label> 
                            <br />
                            <span style="font-size: 12px; font-weight: 300;">
                            (<?php lang::get('Stop words')?>)
                            </span>
                        </th>
                        <td> <textarea cols="80" style="resize:none;" name="black_words" id="black-words"><?php echo $black_words; ?></textarea> </td>
                    </tr>
                    <tr>
                        <th></th>
                        <td>
                            <input type="radio" name="links_category" id="links-category_1" value="1" <?php echo ( ($link_in_one_category == 1) ? 'checked="checked"' : '' );?> > 
                            <label for="links-category_1"><?php lang::get('Linking posts among themselves within one category')?></label>
                        </td>
                    </tr>
                    <tr>
                        <th></th>
                        <td>
                            <input type="radio" name="links_category" id="links-category_0" value="0" <?php echo ( ($link_in_one_category == 0) ? 'checked="checked"' : '' );?> >
                            <label for="links-category_0"><?php lang::get('Linking posts among themselves between all categories')?></label>
                        </td>
                    </tr>
                    <tr>
                        <th></th>
                        <td><input type="submit" class="button button-primary" value="<?php lang::get("Save"); ?>" /> </td>
                    </tr>
                </table>
            </div>
        </div>
        <table class="wp-list-table widefat fixed tags">
            <thead>
                <tr>
                    <th align="center" width="150" class="title-table"><?php lang::get("Name"); ?></th>
                    <th align="center" width="300" class="title-table"><?php lang::get("Description"); ?></th>
                    <th align="center" width="150" class="title-table"><?php lang::get("Label"); ?></th>
                    <th width="90" align="center" class="title-table"><?php lang::get("Post Count"); ?></th>
                    <th align="center" class="title-table"><?php lang::get("Link anchors"); ?><br />(<a style="font-size: 12px;" href="javascript:void(0)" onclick="showModal('info-details')"><?php lang::get("explanation"); ?></a>)</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($categories as $category) {
                        $linking_text = self::getLiningByCat($category->cat_ID);
                    ?> 
                    <tr>
                        <td >
                            <strong>
                                <a href="edit-tags.php?action=edit&taxonomy=category&tag_ID=<?php echo $category->cat_ID; ?>&post_type=post" target="_blank"><?php echo $category->name?></a>
                            </strong>
                        </td>
                        <td ><?php echo $category->description; ?></td>
                        <td ><?php echo urldecode( $category->slug ); ?></td>
                        <td ><a href="edit.php?category_name=<?php echo $category->slug;?>"><?php echo $category->count; ?></a></td>
                        <td ><?php echo $linking_text[0]['linking_text']; ?></td>
                    </tr>
                    <?php
                }?>
            </tbody>
        </table>
    </form>
</div>